/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines.enchanting;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.items.settings.IntRangeSetting;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

abstract class AbstractEnchantmentMachine
extends AContainer {
    private final ItemSetting<Boolean> useLevelLimit = new ItemSetting<Boolean>(this, "use-enchant-level-limit", false);
    private final IntRangeSetting levelLimit = new IntRangeSetting(this, "enchant-level-limit", 0, 10, Short.MAX_VALUE);
    private final ItemSetting<Integer> maxEnchants = new IntRangeSetting(this, "max-enchants", 0, 10, Short.MAX_VALUE);
    private final ItemSetting<Boolean> useMaxEnchants = new ItemSetting<Boolean>(this, "use-max-enchants", false);
    private final ItemSetting<Boolean> useIgnoredLores = new ItemSetting<Boolean>(this, "use-ignored-lores", false);
    private final ItemSetting<List<String>> ignoredLores = new ItemSetting<List<CallSite>>(this, "ignored-lores", Collections.singletonList("&7- &cCan't be used in " + this.getItemName()));

    @ParametersAreNonnullByDefault
    protected AbstractEnchantmentMachine(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        this.addItemSetting(this.useLevelLimit);
        this.addItemSetting(this.levelLimit);
        this.addItemSetting(this.useIgnoredLores);
        this.addItemSetting(this.ignoredLores);
        this.addItemSetting(this.maxEnchants);
        this.addItemSetting(this.useMaxEnchants);
    }

    protected boolean isEnchantmentLevelAllowed(int enchantmentLevel) {
        return this.useLevelLimit.getValue() == false || (Integer)this.levelLimit.getValue() >= enchantmentLevel;
    }

    protected void showEnchantmentLevelWarning(@Nonnull BlockMenu menu) {
        if (!this.useLevelLimit.getValue().booleanValue()) {
            throw new IllegalStateException("Enchantment level limit not enabled, cannot display a warning.");
        }
        String notice = ChatColors.color(Slimefun.getLocalization().getMessage("messages.above-limit-level"));
        notice = notice.replace("%level%", String.valueOf(this.levelLimit.getValue()));
        ItemStack progressBar = CustomItemStack.create(Material.BARRIER, " ", notice);
        menu.replaceExistingItem(22, progressBar);
    }

    protected boolean hasIgnoredLore(@Nonnull ItemStack item) {
        ItemMeta itemMeta;
        if (this.useIgnoredLores.getValue().booleanValue() && item.hasItemMeta() && (itemMeta = item.getItemMeta()).hasLore()) {
            List itemLore = itemMeta.getLore();
            List<String> ignoredLore = this.ignoredLores.getValue();
            for (String lore : ignoredLore) {
                if (!itemLore.contains(ChatColors.color(lore))) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isEnchantmentAmountAllowed(int numberOfEnchants) {
        if (!this.useMaxEnchants.getValue().booleanValue()) {
            return true;
        }
        return numberOfEnchants <= this.maxEnchants.getValue();
    }
}

