/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.integrations;

import com.gmail.nossr50.events.skills.salvage.McMMOPlayerSalvageCheckEvent;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.skills.SkillUtils;
import io.github.thebusybiscuit.slimefun4.api.events.AutoDisenchantEvent;
import io.github.thebusybiscuit.slimefun4.api.events.BlockPlacerPlaceEvent;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.VanillaItem;
import javax.annotation.Nonnull;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

class McMMOIntegration
implements Listener {
    private final Slimefun plugin;

    McMMOIntegration(@Nonnull Slimefun plugin) {
        this.plugin = plugin;
    }

    public void register() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPlacerPlace(BlockPlacerPlaceEvent e) {
        try {
            mcMMO.getPlaceStore().setTrue(e.getBlock());
        }
        catch (Exception | LinkageError x) {
            Slimefun.getIntegrations().logError("mcMMO", x);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onItemSalvage(McMMOPlayerSalvageCheckEvent e) {
        if (!this.isSalvageable(e.getSalvageItem())) {
            e.setCancelled(true);
            Slimefun.getLocalization().sendMessage((CommandSender)e.getPlayer(), "anvil.mcmmo-salvaging");
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onAutoDisenchant(AutoDisenchantEvent e) {
        try {
            SkillUtils.removeAbilityBuff((ItemStack)e.getItem());
        }
        catch (Exception | LinkageError x) {
            Slimefun.getIntegrations().logError("mcMMO", x);
        }
    }

    private boolean isSalvageable(@Nonnull ItemStack item) {
        SlimefunItem sfItem = SlimefunItem.getByItem(item);
        return sfItem == null || sfItem instanceof VanillaItem;
    }
}

