/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.blocks;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockUseHandler;
import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundEffect;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.github.thebusybiscuit.slimefun4.utils.compatibility.VersionedParticle;
import io.github.thebusybiscuit.slimefun4.utils.tags.SlimefunTag;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Crucible
extends SimpleSlimefunItem<BlockUseHandler>
implements RecipeDisplayItem {
    private final ItemSetting<Boolean> allowWaterInNether = new ItemSetting<Boolean>(this, "allow-water-in-nether", false);
    private final List<ItemStack> recipes = this.getMachineRecipes();

    @ParametersAreNonnullByDefault
    public Crucible(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        this.addItemSetting(this.allowWaterInNether);
    }

    @Override
    public List<ItemStack> getDisplayRecipes() {
        return this.recipes;
    }

    @Nonnull
    private List<ItemStack> getMachineRecipes() {
        LinkedList<ItemStack> items = new LinkedList<ItemStack>();
        items.add(new ItemStack(Material.COBBLESTONE, 16));
        items.add(new ItemStack(Material.LAVA_BUCKET));
        items.add(new ItemStack(Material.NETHERRACK, 16));
        items.add(new ItemStack(Material.LAVA_BUCKET));
        items.add(new ItemStack(Material.STONE, 12));
        items.add(new ItemStack(Material.LAVA_BUCKET));
        items.add(new ItemStack(Material.OBSIDIAN, 1));
        items.add(new ItemStack(Material.LAVA_BUCKET));
        items.add(new ItemStack(Material.TERRACOTTA, 12));
        items.add(new ItemStack(Material.LAVA_BUCKET));
        for (Material leave : Tag.LEAVES.getValues()) {
            items.add(new ItemStack(leave, 16));
            items.add(new ItemStack(Material.WATER_BUCKET));
        }
        for (Material sapling : SlimefunTag.TERRACOTTA.getValues()) {
            items.add(new ItemStack(sapling, 12));
            items.add(new ItemStack(Material.LAVA_BUCKET));
        }
        items.add(new ItemStack(Material.BLACKSTONE, 8));
        items.add(new ItemStack(Material.LAVA_BUCKET));
        items.add(new ItemStack(Material.BASALT, 12));
        items.add(new ItemStack(Material.LAVA_BUCKET));
        if (Slimefun.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_17)) {
            items.add(new ItemStack(Material.COBBLED_DEEPSLATE, 12));
            items.add(new ItemStack(Material.LAVA_BUCKET));
            items.add(new ItemStack(Material.DEEPSLATE, 10));
            items.add(new ItemStack(Material.LAVA_BUCKET));
            items.add(new ItemStack(Material.TUFF, 8));
            items.add(new ItemStack(Material.LAVA_BUCKET));
        }
        return items;
    }

    @Override
    public BlockUseHandler getItemHandler() {
        return e -> {
            Optional<Block> optional = e.getClickedBlock();
            if (optional.isPresent()) {
                e.cancel();
                Player p = e.getPlayer();
                Block b = optional.get();
                if (p.hasPermission("slimefun.inventory.bypass") || Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), Interaction.INTERACT_BLOCK)) {
                    ItemStack input = e.getItem();
                    Block block = b.getRelative(BlockFace.UP);
                    if (this.craft(p, input)) {
                        boolean water = Tag.LEAVES.isTagged((Keyed)input.getType());
                        this.generateLiquid(block, water);
                    } else {
                        Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.wrong-item", true);
                    }
                }
            }
        };
    }

    @ParametersAreNonnullByDefault
    private boolean craft(Player p, ItemStack input) {
        for (int i = 0; i < this.recipes.size(); i += 2) {
            ItemStack catalyst = this.recipes.get(i);
            if (!SlimefunUtils.isItemSimilar(input, catalyst, true)) continue;
            ItemStack removing = input.clone();
            removing.setAmount(catalyst.getAmount());
            p.getInventory().removeItem(new ItemStack[]{removing});
            return true;
        }
        return false;
    }

    private void generateLiquid(@Nonnull Block block, boolean isWater) {
        if (isWater && block.getWorld().getEnvironment() == World.Environment.NETHER && !this.allowWaterInNether.getValue().booleanValue()) {
            block.getWorld().spawnParticle(VersionedParticle.SMOKE, block.getLocation().add(0.5, 0.5, 0.5), 4);
            SoundEffect.CRUCIBLE_GENERATE_LIQUID_SOUND.playAt(block);
            return;
        }
        if (block.getType() == (isWater ? Material.WATER : Material.LAVA)) {
            this.addLiquidLevel(block, isWater);
        } else if (block.getType() == (isWater ? Material.LAVA : Material.WATER)) {
            int level = ((Levelled)block.getBlockData()).getLevel();
            block.setType(level == 0 || level == 8 ? Material.OBSIDIAN : Material.STONE);
            SoundEffect.CRUCIBLE_GENERATE_LIQUID_SOUND.playAt(block);
        } else {
            Slimefun.runSync(() -> this.placeLiquid(block, isWater), 50L);
        }
    }

    private void addLiquidLevel(@Nonnull Block block, boolean water) {
        int level = ((Levelled)block.getBlockData()).getLevel();
        if (level > 7) {
            level -= 8;
        }
        if (level == 0) {
            Slimefun.runSync(() -> this.runPostTask(block, water ? SoundEffect.CRUCIBLE_ADD_WATER_SOUND : SoundEffect.CRUCIBLE_ADD_LAVA_SOUND, 1));
        } else {
            int finalLevel = 7 - level;
            Slimefun.runSync(() -> this.runPostTask(block, water ? SoundEffect.CRUCIBLE_ADD_WATER_SOUND : SoundEffect.CRUCIBLE_ADD_LAVA_SOUND, finalLevel), 50L);
        }
    }

    private void placeLiquid(@Nonnull Block block, boolean water) {
        if (block.getType().isAir()) {
            block.setType(water ? Material.WATER : Material.LAVA, false);
        } else {
            BlockData blockData;
            if (water && (blockData = block.getBlockData()) instanceof Waterlogged) {
                Waterlogged waterlogged = (Waterlogged)blockData;
                waterlogged.setWaterlogged(true);
                block.setBlockData((BlockData)waterlogged, false);
                SoundEffect.CRUCIBLE_PLACE_WATER_SOUND.playAt(block);
                return;
            }
            if (BlockStorage.hasBlockInfo(block)) {
                BlockStorage.clearBlockInfo(block);
            }
        }
        this.runPostTask(block, water ? SoundEffect.CRUCIBLE_PLACE_WATER_SOUND : SoundEffect.CRUCIBLE_PLACE_LAVA_SOUND, 1);
    }

    @ParametersAreNonnullByDefault
    private void runPostTask(Block block, SoundEffect sound, int times) {
        BlockData blockData = block.getBlockData();
        if (!(blockData instanceof Levelled)) {
            SoundEffect.CRUCIBLE_BLOCK_BREAK_SOUND.playAt(block);
            return;
        }
        Levelled le = (Levelled)blockData;
        sound.playAt(block);
        int level = 8 - times;
        le.setLevel(level);
        block.setBlockData((BlockData)le, false);
        if (times < 8) {
            Slimefun.runSync(() -> this.runPostTask(block, sound, times + 1), 50L);
        } else {
            SoundEffect.CRUCIBLE_INTERACT_SOUND.playAt(block);
        }
    }
}

