/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.plugin.java.JavaPlugin;

public final class ThreadService {
    private final ThreadGroup group;
    private final ExecutorService cachedPool;
    private final ScheduledExecutorService scheduledPool;

    public ThreadService(final JavaPlugin plugin) {
        this.group = new ThreadGroup(plugin.getName());
        this.cachedPool = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(ThreadService.this.group, r, plugin.getName() + " - ThreadService");
            }
        });
        this.scheduledPool = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(ThreadService.this.group, r, plugin.getName() + " - ScheduledThreadService");
            }
        });
    }

    @ParametersAreNonnullByDefault
    public void newThread(JavaPlugin plugin, String name, Runnable runnable) {
        this.cachedPool.submit(() -> {
            Thread.currentThread().setName(plugin.getName() + " - " + name);
            runnable.run();
        });
    }

    @ParametersAreNonnullByDefault
    public void newScheduledThread(JavaPlugin plugin, String name, Runnable runnable, long delay, long period, TimeUnit unit) {
        this.scheduledPool.scheduleWithFixedDelay(() -> {
            Thread.currentThread().setName(plugin.getName() + " - " + name);
            runnable.run();
        }, delay, delay, unit);
    }

    public static String getCaller() {
        StackTraceElement element = Thread.currentThread().getStackTrace()[3];
        return element.getClassName() + "." + element.getMethodName() + ":" + element.getLineNumber();
    }
}

