/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.weapons;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.items.settings.IntRangeSetting;
import io.github.thebusybiscuit.slimefun4.core.handlers.BowShootHandler;
import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundEffect;
import io.github.thebusybiscuit.slimefun4.implementation.items.weapons.SlimefunBow;
import io.github.thebusybiscuit.slimefun4.utils.compatibility.VersionedParticle;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Bukkit;
import org.bukkit.SoundCategory;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class ExplosiveBow
extends SlimefunBow {
    private final ItemSetting<Integer> range = new IntRangeSetting(this, "explosion-range", 1, 3, Integer.MAX_VALUE);

    @ParametersAreNonnullByDefault
    public ExplosiveBow(ItemGroup itemGroup, SlimefunItemStack item, ItemStack[] recipe) {
        super(itemGroup, item, recipe);
        this.addItemSetting(this.range);
    }

    @Override
    @Nonnull
    public BowShootHandler onShoot() {
        return (e, target) -> {
            target.getWorld().spawnParticle(VersionedParticle.EXPLOSION, target.getLocation(), 1);
            SoundEffect.EXPLOSIVE_BOW_HIT_SOUND.playAt(target.getLocation(), SoundCategory.PLAYERS);
            int radius = this.range.getValue();
            Collection entities = target.getWorld().getNearbyEntities(target.getLocation(), (double)radius, (double)radius, (double)radius, this::canDamage);
            for (Entity nearby : entities) {
                LivingEntity entity = (LivingEntity)nearby;
                Vector distanceVector = entity.getLocation().toVector().subtract(target.getLocation().toVector()).add(new Vector(0.0, 0.75, 0.0));
                double distanceSquared = distanceVector.lengthSquared();
                double damage = e.getDamage() * (1.0 - distanceSquared / (double)(2 * this.range.getValue() * this.range.getValue()));
                if (entity.getUniqueId().equals(target.getUniqueId())) continue;
                EntityDamageByEntityEvent event = new EntityDamageByEntityEvent(e.getDamager(), (Entity)entity, EntityDamageEvent.DamageCause.ENTITY_EXPLOSION, damage);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                distanceVector.setY(0.75);
                Vector knockback = distanceVector.normalize().multiply(2);
                entity.setVelocity(entity.getVelocity().add(knockback));
                entity.damage(event.getDamage());
            }
        };
    }

    private boolean canDamage(@Nonnull Entity entity) {
        return entity instanceof LivingEntity && !(entity instanceof ArmorStand) && entity.isValid();
    }
}

