/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.multiblocks;

import io.github.thebusybiscuit.slimefun4.api.events.MultiBlockCraftEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlockMachine;
import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundEffect;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.backpacks.SlimefunBackpack;
import io.github.thebusybiscuit.slimefun4.implementation.items.multiblocks.AbstractCraftingTable;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Dispenser;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class MagicWorkbench
extends AbstractCraftingTable {
    @ParametersAreNonnullByDefault
    public MagicWorkbench(ItemGroup itemGroup, SlimefunItemStack item) {
        super(itemGroup, item, new ItemStack[]{null, null, null, null, null, null, new ItemStack(Material.BOOKSHELF), new ItemStack(Material.CRAFTING_TABLE), new ItemStack(Material.DISPENSER)}, BlockFace.UP);
    }

    @Override
    public void onInteract(Player p, Block b) {
        Block possibleDispener = this.locateDispenser(b);
        if (possibleDispener == null) {
            return;
        }
        BlockState state = PaperLib.getBlockState(possibleDispener, false).getState();
        if (state instanceof Dispenser) {
            Dispenser dispenser = (Dispenser)state;
            Inventory inv = dispenser.getInventory();
            List<ItemStack[]> inputs = RecipeType.getRecipeInputList(this);
            for (ItemStack[] input : inputs) {
                if (!this.isCraftable(inv, input)) continue;
                ItemStack output = RecipeType.getRecipeOutputList(this, input).clone();
                MultiBlockCraftEvent event = new MultiBlockCraftEvent(p, (MultiBlockMachine)this, input, output);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (!event.isCancelled() && SlimefunUtils.canPlayerUseItem(p, output, true)) {
                    this.craft(inv, possibleDispener, p, b, event.getOutput());
                }
                return;
            }
            if (inv.isEmpty()) {
                Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.inventory-empty", true);
            } else {
                Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.pattern-not-found", true);
            }
        }
    }

    @ParametersAreNonnullByDefault
    private void craft(Inventory inv, Block dispenser, Player p, Block b, ItemStack output) {
        Inventory fakeInv = this.createVirtualInventory(inv);
        Inventory outputInv = this.findOutputInventory(output, dispenser, inv, fakeInv);
        if (outputInv != null) {
            SlimefunItem sfItem = SlimefunItem.getByItem(output);
            if (sfItem instanceof SlimefunBackpack) {
                SlimefunBackpack backpack = (SlimefunBackpack)sfItem;
                this.upgradeBackpack(p, inv, backpack, output);
            }
            for (int j = 0; j < 9; ++j) {
                if (inv.getContents()[j] == null || inv.getContents()[j].getType() == Material.AIR) continue;
                if (inv.getContents()[j].getAmount() > 1) {
                    inv.setItem(j, CustomItemStack.create(inv.getContents()[j], inv.getContents()[j].getAmount() - 1));
                    continue;
                }
                inv.setItem(j, null);
            }
            this.startAnimation(p, b, inv, dispenser, output);
        } else {
            Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.full-inventory", true);
        }
    }

    private void startAnimation(Player p, Block b, Inventory dispInv, Block dispenser, ItemStack output) {
        for (int j = 0; j < 4; ++j) {
            int current = j;
            Slimefun.runSync(() -> {
                p.getWorld().playEffect(b.getLocation(), Effect.MOBSPAWNER_FLAMES, 1);
                p.getWorld().playEffect(b.getLocation(), Effect.ENDER_SIGNAL, 1);
                if (current < 3) {
                    SoundEffect.MAGIC_WORKBENCH_START_ANIMATION_SOUND.playAt(b);
                } else {
                    SoundEffect.MAGIC_WORKBENCH_FINISH_SOUND.playAt(b);
                    this.handleCraftedItem(output, dispenser, dispInv);
                }
            }, (long)j * 20L);
        }
    }

    private Block locateDispenser(Block b) {
        Block block = null;
        if (b.getRelative(1, 0, 0).getType() == Material.DISPENSER) {
            block = b.getRelative(1, 0, 0);
        } else if (b.getRelative(0, 0, 1).getType() == Material.DISPENSER) {
            block = b.getRelative(0, 0, 1);
        } else if (b.getRelative(-1, 0, 0).getType() == Material.DISPENSER) {
            block = b.getRelative(-1, 0, 0);
        } else if (b.getRelative(0, 0, -1).getType() == Material.DISPENSER) {
            block = b.getRelative(0, 0, -1);
        }
        return block;
    }

    private boolean isCraftable(Inventory inv, ItemStack[] recipe) {
        for (int j = 0; j < inv.getContents().length; ++j) {
            if (SlimefunUtils.isItemSimilar(inv.getContents()[j], recipe[j], true, true, false)) continue;
            if (SlimefunItem.getByItem(recipe[j]) instanceof SlimefunBackpack) {
                if (SlimefunUtils.isItemSimilar(inv.getContents()[j], recipe[j], false, true, false)) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

