/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.events;

import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;

public class WaypointCreateEvent
extends PlayerEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private Location location;
    private String name;
    private final boolean deathpoint;
    private boolean cancelled;

    public WaypointCreateEvent(@Nonnull Player player, @Nonnull String name, @Nonnull Location location) {
        super(player);
        Validate.notNull(location, "Location must not be null!");
        Validate.notNull(name, "Name must not be null!");
        this.location = location;
        this.name = name;
        this.deathpoint = name.startsWith("player:death ");
    }

    @Nonnull
    public Location getLocation() {
        return this.location;
    }

    public void setLocation(@Nonnull Location loc) {
        Validate.notNull(loc, "Cannot set the Location to null!");
        this.location = loc;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        Validate.notEmpty(name, "The name of a waypoint must not be empty!");
        this.name = name;
    }

    public boolean isDeathpoint() {
        return this.deathpoint;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Nonnull
    public static HandlerList getHandlerList() {
        return handlers;
    }

    @Nonnull
    public HandlerList getHandlers() {
        return WaypointCreateEvent.getHandlerList();
    }
}

