/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.utils;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.api.events.SlimefunItemSpawnEvent;
import io.github.thebusybiscuit.slimefun4.api.exceptions.PrematureCodeException;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSpawnReason;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.core.attributes.DistinctiveItem;
import io.github.thebusybiscuit.slimefun4.core.attributes.Radioactive;
import io.github.thebusybiscuit.slimefun4.core.attributes.Soulbound;
import io.github.thebusybiscuit.slimefun4.core.debug.Debug;
import io.github.thebusybiscuit.slimefun4.core.debug.TestCase;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.CapacitorTextureUpdateTask;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.CommonPatterns;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemMetaSnapshot;
import io.github.thebusybiscuit.slimefun4.libraries.dough.skins.PlayerHead;
import io.github.thebusybiscuit.slimefun4.libraries.dough.skins.PlayerSkin;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.ItemStackWrapper;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public final class SlimefunUtils {
    private static final String NO_PICKUP_METADATA = "no_pickup";
    private static final String SOULBOUND_LORE = String.valueOf(ChatColor.GRAY) + "Soulbound";

    private SlimefunUtils() {
    }

    public static boolean hasNoPickupFlag(@Nonnull Item item) {
        return item.hasMetadata(NO_PICKUP_METADATA);
    }

    public static void markAsNoPickup(@Nonnull Item item, @Nonnull String context) {
        item.setMetadata(NO_PICKUP_METADATA, (MetadataValue)new FixedMetadataValue((Plugin)Slimefun.instance(), (Object)context));
        item.setPickupDelay(Short.MAX_VALUE);
    }

    public static boolean isSoulbound(@Nullable ItemStack item) {
        return SlimefunUtils.isSoulbound(item, null);
    }

    public static boolean isSoulbound(@Nullable ItemStack item, @Nullable World world) {
        if (item != null && item.getType() != Material.AIR) {
            ItemMeta meta = item.hasItemMeta() ? item.getItemMeta() : null;
            SlimefunItem rune = SlimefunItems.SOULBOUND_RUNE.getItem();
            if (!(rune == null || rune.isDisabled() || world != null && rune.isDisabledIn(world) || !SlimefunUtils.hasSoulboundFlag(meta))) {
                return true;
            }
            SlimefunItem sfItem = SlimefunItem.getByItem(item);
            if (sfItem instanceof Soulbound) {
                if (world != null) {
                    return !sfItem.isDisabledIn(world);
                }
                return !sfItem.isDisabled();
            }
            if (meta != null) {
                return meta.hasLore() && meta.getLore().contains(SOULBOUND_LORE);
            }
        }
        return false;
    }

    private static boolean hasSoulboundFlag(@Nullable ItemMeta meta) {
        if (meta != null) {
            PersistentDataContainer container = meta.getPersistentDataContainer();
            NamespacedKey key = Slimefun.getRegistry().getSoulboundDataKey();
            return container.has(key, PersistentDataType.BYTE);
        }
        return false;
    }

    public static void setSoulbound(@Nullable ItemStack item, boolean makeSoulbound) {
        List lore;
        if (item == null || item.getType() == Material.AIR) {
            throw new IllegalArgumentException("A soulbound item cannot be null or air!");
        }
        boolean isSoulbound = SlimefunUtils.isSoulbound(item);
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        NamespacedKey key = Slimefun.getRegistry().getSoulboundDataKey();
        if (makeSoulbound && !isSoulbound) {
            container.set(key, PersistentDataType.BYTE, (Object)1);
        }
        if (!makeSoulbound && isSoulbound) {
            container.remove(key);
        }
        List list = lore = meta.hasLore() ? meta.getLore() : new ArrayList();
        if (makeSoulbound && !isSoulbound) {
            lore.add(SOULBOUND_LORE);
        }
        if (!makeSoulbound && isSoulbound) {
            lore.remove(SOULBOUND_LORE);
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
    }

    public static boolean isRadioactive(@Nullable ItemStack item) {
        return SlimefunItem.getByItem(item) instanceof Radioactive;
    }

    @Nonnull
    public static ItemStack getCustomHead(@Nonnull String texture) {
        Validate.notNull(texture, "The provided texture is null");
        if (Slimefun.instance() == null) {
            throw new PrematureCodeException("You cannot instantiate a custom head before Slimefun was loaded.");
        }
        if (Slimefun.getMinecraftVersion() == MinecraftVersion.UNIT_TEST) {
            return new ItemStack(Material.PLAYER_HEAD);
        }
        String base64 = texture;
        if (CommonPatterns.HEXADECIMAL.matcher(texture).matches()) {
            base64 = Base64.getEncoder().encodeToString(("{\"textures\":{\"SKIN\":{\"url\":\"http://textures.minecraft.net/texture/" + texture + "\"}}}").getBytes(StandardCharsets.UTF_8));
        }
        PlayerSkin skin = PlayerSkin.fromBase64(base64);
        return PlayerHead.getItemStack(skin);
    }

    public static boolean containsSimilarItem(Inventory inventory, ItemStack item, boolean checkLore) {
        if (inventory == null || item == null) {
            return false;
        }
        SlimefunItem slimefunItem = SlimefunItem.getByItem(item);
        if (slimefunItem != null) {
            item = ItemStackWrapper.wrap(item);
        }
        for (ItemStack stack : inventory.getStorageContents()) {
            if (stack == null || stack.getType() == Material.AIR || !SlimefunUtils.isItemSimilar(stack, item, checkLore, false, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean isItemSimilar(@Nullable ItemStack item, @Nullable ItemStack sfitem, boolean checkLore) {
        return SlimefunUtils.isItemSimilar(item, sfitem, checkLore, true, true);
    }

    public static boolean isItemSimilar(@Nullable ItemStack item, @Nullable ItemStack sfitem, boolean checkLore, boolean checkAmount) {
        return SlimefunUtils.isItemSimilar(item, sfitem, checkLore, checkAmount, true);
    }

    public static boolean isItemSimilar(@Nullable ItemStack item, @Nullable ItemStack sfitem, boolean checkLore, boolean checkAmount, boolean checkDistinction) {
        if (item == null) {
            return sfitem == null;
        }
        if (sfitem == null) {
            return false;
        }
        if (item.getType() != sfitem.getType()) {
            return false;
        }
        if (checkAmount && item.getAmount() < sfitem.getAmount()) {
            return false;
        }
        SlimefunItem sf_sfitem = SlimefunItem.getByItem(sfitem);
        SlimefunItem sf_item = SlimefunItem.getByItem(item);
        if (sf_sfitem != null && sf_item != null) {
            if (!sf_sfitem.getId().equals(sf_item.getId())) {
                return false;
            }
            if (checkDistinction && sf_sfitem instanceof DistinctiveItem) {
                DistinctiveItem distinctive = (DistinctiveItem)((Object)sf_sfitem);
                if (sf_item instanceof DistinctiveItem) {
                    return distinctive.canStack(sf_sfitem.getItem().getItemMeta(), sf_item.getItem().getItemMeta());
                }
            }
            return true;
        }
        if (item.hasItemMeta()) {
            Debug.log(TestCase.CARGO_INPUT_TESTING, "SlimefunUtils#isItemSimilar - item.hasItemMeta()");
            ItemMeta itemMeta = item.getItemMeta();
            if (sf_sfitem != null) {
                String id = Slimefun.getItemDataService().getItemData(itemMeta).orElse(null);
                if (id != null) {
                    Optional<DistinctiveItem> optionalDistinctive;
                    if (checkDistinction && (optionalDistinctive = SlimefunUtils.getDistinctiveItem(id)).isPresent()) {
                        ItemMeta sfItemMeta = sfitem.getItemMeta();
                        return optionalDistinctive.get().canStack(sfItemMeta, itemMeta);
                    }
                    return id.equals(sf_sfitem.getId());
                }
                ItemMeta meta = sf_sfitem.getItem().getItemMeta();
                return SlimefunUtils.equalsItemMeta(itemMeta, meta, checkLore);
            }
            if (sfitem instanceof ItemStackWrapper && sfitem.hasItemMeta()) {
                Debug.log(TestCase.CARGO_INPUT_TESTING, "  is wrapper");
                Debug.log(TestCase.CARGO_INPUT_TESTING, "  sfitem is ItemStackWrapper - possible SF Item: {}", sfitem);
                ItemMeta possibleSfItemMeta = sfitem.getItemMeta();
                String id = Slimefun.getItemDataService().getItemData(itemMeta).orElse(null);
                String possibleItemId = Slimefun.getItemDataService().getItemData(possibleSfItemMeta).orElse(null);
                if (id != null && id.equals(possibleItemId)) {
                    Debug.log(TestCase.CARGO_INPUT_TESTING, "  Item IDs matched!");
                    Optional<DistinctiveItem> optionalDistinctive = SlimefunUtils.getDistinctiveItem(id);
                    if (optionalDistinctive.isPresent()) {
                        return optionalDistinctive.get().canStack(possibleSfItemMeta, itemMeta);
                    }
                    return true;
                }
                Debug.log(TestCase.CARGO_INPUT_TESTING, "  Item IDs don't match, checking meta {} == {} (lore: {})", itemMeta, possibleSfItemMeta, checkLore);
                return SlimefunUtils.equalsItemMeta(itemMeta, possibleSfItemMeta, checkLore);
            }
            if (sfitem.hasItemMeta()) {
                ItemMeta sfItemMeta = sfitem.getItemMeta();
                Debug.log(TestCase.CARGO_INPUT_TESTING, "  Comparing meta (vanilla items?) - {} == {} (lore: {})", itemMeta, sfItemMeta, checkLore);
                return SlimefunUtils.equalsItemMeta(itemMeta, sfItemMeta, checkLore);
            }
            return false;
        }
        return !sfitem.hasItemMeta();
    }

    @Nonnull
    private static Optional<DistinctiveItem> getDistinctiveItem(@Nonnull String id) {
        SlimefunItem slimefunItem = SlimefunItem.getById(id);
        if (slimefunItem instanceof DistinctiveItem) {
            DistinctiveItem distinctive = (DistinctiveItem)((Object)slimefunItem);
            return Optional.of(distinctive);
        }
        return Optional.empty();
    }

    private static boolean equalsItemMeta(@Nonnull ItemMeta itemMeta, @Nonnull ItemMetaSnapshot itemMetaSnapshot, boolean checkLore) {
        Optional<String> displayName = itemMetaSnapshot.getDisplayName();
        if (itemMeta.hasDisplayName() != displayName.isPresent()) {
            return false;
        }
        if (itemMeta.hasDisplayName() && displayName.isPresent() && !itemMeta.getDisplayName().equals(displayName.get())) {
            return false;
        }
        if (checkLore) {
            Optional<List<String>> itemLore = itemMetaSnapshot.getLore();
            if (itemMeta.hasLore() && itemLore.isPresent() && !SlimefunUtils.equalsLore(itemMeta.getLore(), itemLore.get())) {
                return false;
            }
            if (itemMeta.hasLore() != itemLore.isPresent()) {
                return false;
            }
        }
        OptionalInt itemCustomModelData = itemMetaSnapshot.getCustomModelData();
        if (itemMeta.hasCustomModelData() && itemCustomModelData.isPresent() && itemMeta.getCustomModelData() != itemCustomModelData.getAsInt()) {
            return false;
        }
        return itemMeta.hasCustomModelData() == itemCustomModelData.isPresent();
    }

    private static boolean equalsItemMeta(@Nonnull ItemMeta itemMeta, @Nonnull ItemMeta sfitemMeta, boolean checkLore) {
        PotionMeta potionMeta;
        block13: {
            block12: {
                if (itemMeta.hasDisplayName() != sfitemMeta.hasDisplayName()) {
                    return false;
                }
                if (itemMeta.hasDisplayName() && sfitemMeta.hasDisplayName() && !itemMeta.getDisplayName().equals(sfitemMeta.getDisplayName())) {
                    return false;
                }
                if (checkLore) {
                    boolean hasItemMetaLore = itemMeta.hasLore();
                    boolean hasSfItemMetaLore = sfitemMeta.hasLore();
                    if (hasItemMetaLore && hasSfItemMetaLore ? !SlimefunUtils.equalsLore(itemMeta.getLore(), sfitemMeta.getLore()) : hasItemMetaLore != hasSfItemMetaLore) {
                        return false;
                    }
                }
                boolean hasItemMetaCustomModelData = itemMeta.hasCustomModelData();
                boolean hasSfItemMetaCustomModelData = sfitemMeta.hasCustomModelData();
                if (hasItemMetaCustomModelData && hasSfItemMetaCustomModelData && itemMeta.getCustomModelData() != sfitemMeta.getCustomModelData()) {
                    return false;
                }
                if (hasItemMetaCustomModelData != hasSfItemMetaCustomModelData) {
                    return false;
                }
                if (!(itemMeta instanceof PotionMeta)) break block12;
                potionMeta = (PotionMeta)itemMeta;
                if (sfitemMeta instanceof PotionMeta) break block13;
            }
            return true;
        }
        PotionMeta sfPotionMeta = (PotionMeta)sfitemMeta;
        MinecraftVersion current = Slimefun.getMinecraftVersion();
        if (current.isBefore(20, 2)) {
            return potionMeta.getBasePotionData().equals((Object)sfPotionMeta.getBasePotionData());
        }
        if (current.isBefore(20, 5)) {
            return potionMeta.getBasePotionType() == sfPotionMeta.getBasePotionType();
        }
        if (potionMeta.hasBasePotionType() != sfPotionMeta.hasBasePotionType()) {
            return false;
        }
        return potionMeta.getBasePotionType() == sfPotionMeta.getBasePotionType();
    }

    public static boolean equalsLore(@Nonnull List<String> lore1, @Nonnull List<String> lore2) {
        Validate.notNull(lore1, "Cannot compare lore that is null!");
        Validate.notNull(lore2, "Cannot compare lore that is null!");
        List<String> longerList = lore1.size() > lore2.size() ? lore1 : lore2;
        List<String> shorterList = lore1.size() > lore2.size() ? lore2 : lore1;
        int b = 0;
        for (int a = 0; a < longerList.size(); ++a) {
            if (SlimefunUtils.isLineIgnored(longerList.get(a))) continue;
            while (shorterList.size() > b && SlimefunUtils.isLineIgnored(shorterList.get(b))) {
                ++b;
            }
            if (b >= shorterList.size()) {
                return false;
            }
            if (longerList.get(a).equals(shorterList.get(b))) {
                ++b;
                continue;
            }
            return false;
        }
        while (shorterList.size() > b && SlimefunUtils.isLineIgnored(shorterList.get(b))) {
            ++b;
        }
        return b == shorterList.size();
    }

    private static boolean isLineIgnored(@Nonnull String line) {
        return line.equals(SOULBOUND_LORE);
    }

    public static void updateCapacitorTexture(@Nonnull Location l, int charge, int capacity) {
        Validate.notNull(l, "Cannot update a texture for null");
        Validate.isTrue(capacity > 0, "Capacity must be greater than zero!");
        Slimefun.runSync(new CapacitorTextureUpdateTask(l, charge, capacity));
    }

    public static boolean canPlayerUseItem(@Nonnull Player p, @Nullable ItemStack item, boolean sendMessage) {
        Validate.notNull(p, "The player cannot be null");
        SlimefunItem sfItem = SlimefunItem.getByItem(item);
        if (sfItem != null) {
            return sfItem.canUse(p, sendMessage);
        }
        return true;
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public static Item spawnItem(Location loc, ItemStack item, ItemSpawnReason reason, boolean addRandomOffset, @Nullable Player player) {
        SlimefunItemSpawnEvent event = new SlimefunItemSpawnEvent(player, loc, item, reason);
        Slimefun.instance().getServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            World world = event.getLocation().getWorld();
            if (addRandomOffset) {
                return world.dropItemNaturally(event.getLocation(), event.getItemStack());
            }
            return world.dropItem(event.getLocation(), event.getItemStack());
        }
        return null;
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public static Item spawnItem(Location loc, ItemStack item, ItemSpawnReason reason, boolean addRandomOffset) {
        return SlimefunUtils.spawnItem(loc, item, reason, addRandomOffset, null);
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public static Item spawnItem(Location loc, ItemStack item, ItemSpawnReason reason) {
        return SlimefunUtils.spawnItem(loc, item, reason, false);
    }

    public static boolean isInventoryEmpty(@Nonnull Inventory inventory) {
        if (Slimefun.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_16)) {
            return inventory.isEmpty();
        }
        for (ItemStack is : inventory.getStorageContents()) {
            if (is == null || is.getType().isAir()) continue;
            return false;
        }
        return true;
    }
}

