/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.gadgets;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.Rechargeable;
import io.github.thebusybiscuit.slimefun4.core.handlers.EntityInteractHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.ToolUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.electric.gadgets.MultiToolMode;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.utils.compatibility.VersionedEntityType;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;

public class MultiTool
extends SlimefunItem
implements Rechargeable {
    private static final float COST = 0.3f;
    private final List<MultiToolMode> modes = new ArrayList<MultiToolMode>();
    private final float capacity;
    private static final NamespacedKey key = new NamespacedKey((Plugin)Slimefun.instance(), "multitool_mode");
    private static final String LORE_PREFIX = ChatColors.color("&8\u21e8 &7Mode: ");
    private static final Pattern REGEX = Pattern.compile(ChatColors.color("(&c&o)?" + LORE_PREFIX) + "(.+)");

    @ParametersAreNonnullByDefault
    public MultiTool(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, float capacity, String ... items) {
        super(itemGroup, item, recipeType, recipe);
        for (int i = 0; i < items.length; ++i) {
            this.modes.add(new MultiToolMode(this, i, items[i]));
        }
        this.capacity = capacity;
    }

    @Override
    public float getMaxItemCharge(ItemStack item) {
        return this.capacity;
    }

    private int nextIndex(int i) {
        int index = i;
        do {
            if (++index < this.modes.size()) continue;
            index = 0;
        } while (index != i && !this.modes.get(index).isEnabled());
        return index;
    }

    @Nonnull
    protected ItemUseHandler getItemUseHandler() {
        return e -> {
            Player p = e.getPlayer();
            ItemStack item = e.getItem();
            ItemMeta meta = item.getItemMeta();
            e.cancel();
            int index = PersistentDataAPI.getInt((PersistentDataHolder)meta, key, 0);
            SlimefunItem sfItem = this.modes.get(index).getItem();
            if (!p.isSneaking()) {
                if (sfItem != null && this.removeItemCharge(item, 0.3f)) {
                    sfItem.callItemHandler(ItemUseHandler.class, handler -> handler.onRightClick(e));
                }
            } else {
                SlimefunItem selectedItem = this.modes.get(index = this.nextIndex(index)).getItem();
                String itemName = selectedItem != null ? selectedItem.getItemName() : "Unknown";
                Slimefun.getLocalization().sendMessage((CommandSender)p, "messages.multi-tool.mode-change", true, msg -> msg.replace("%device%", "Multi Tool").replace("%mode%", ChatColor.stripColor((String)itemName)));
                PersistentDataAPI.setInt((PersistentDataHolder)meta, key, index);
                List lore = meta.hasLore() ? meta.getLore() : new ArrayList();
                boolean regexMatchFound = false;
                for (int i = 0; i < lore.size(); ++i) {
                    String line = (String)lore.get(i);
                    if (!REGEX.matcher(line).matches()) continue;
                    lore.set(i, LORE_PREFIX + ChatColor.stripColor((String)itemName));
                    regexMatchFound = true;
                    break;
                }
                if (!regexMatchFound) {
                    lore.add(2, LORE_PREFIX + ChatColor.stripColor((String)itemName));
                }
                meta.setLore(lore);
                item.setItemMeta(meta);
            }
        };
    }

    @Nonnull
    private ToolUseHandler getToolUseHandler() {
        return (e, tool, fortune, drops) -> {
            Slimefun.getLocalization().sendMessage((CommandSender)e.getPlayer(), "messages.multi-tool.not-shears");
            e.setCancelled(true);
        };
    }

    @Nonnull
    private EntityInteractHandler getEntityInteractionHandler() {
        return (e, item, offhand) -> {
            EntityType type = e.getRightClicked().getType();
            if (type == VersionedEntityType.MOOSHROOM || type == VersionedEntityType.SNOW_GOLEM || type == EntityType.SHEEP) {
                Slimefun.getLocalization().sendMessage((CommandSender)e.getPlayer(), "messages.multi-tool.not-shears");
                e.setCancelled(true);
            }
        };
    }

    @Override
    public void preRegister() {
        super.preRegister();
        this.addItemHandler(this.getItemUseHandler());
        this.addItemHandler(this.getToolUseHandler());
        this.addItemHandler(this.getEntityInteractionHandler());
    }
}

