/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.tools.GrapplingHook;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.GrapplingHookEntity;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Location;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class GrapplingHookListener
implements Listener {
    private GrapplingHook grapplingHook;
    private final Map<UUID, GrapplingHookEntity> activeHooks = new HashMap<UUID, GrapplingHookEntity>();
    private final Set<UUID> invulnerability = new HashSet<UUID>();

    public void register(@Nonnull Slimefun plugin, @Nonnull GrapplingHook grapplingHook) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.grapplingHook = grapplingHook;
    }

    @EventHandler
    public void onArrowHitEntity(EntityDamageByEntityEvent e) {
        if (this.grapplingHook.isDisabled()) {
            return;
        }
        Entity entity = e.getDamager();
        if (entity instanceof Arrow) {
            Arrow arrow = (Arrow)entity;
            this.handleGrapplingHook(arrow);
        }
    }

    @EventHandler
    public void onArrowHitSurface(ProjectileHitEvent e) {
        if (this.grapplingHook.isDisabled()) {
            return;
        }
        Slimefun.runSync(() -> {
            Projectile patt0$temp = e.getEntity();
            if (patt0$temp instanceof Arrow) {
                Arrow arrow = (Arrow)patt0$temp;
                this.handleGrapplingHook(arrow);
            }
        }, 2L);
    }

    @EventHandler
    public void onArrowHitHanging(HangingBreakByEntityEvent e) {
        if (this.grapplingHook.isDisabled()) {
            return;
        }
        Entity entity = e.getRemover();
        if (entity instanceof Arrow) {
            Arrow arrow = (Arrow)entity;
            this.handleGrapplingHook(arrow);
        }
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent e) {
        if (this.grapplingHook.isDisabled()) {
            return;
        }
        UUID uuid = e.getPlayer().getUniqueId();
        this.activeHooks.remove(uuid);
        this.invulnerability.remove(uuid);
    }

    @EventHandler
    public void onLeave(PlayerKickEvent e) {
        if (this.grapplingHook.isDisabled()) {
            return;
        }
        UUID uuid = e.getPlayer().getUniqueId();
        this.activeHooks.remove(uuid);
        this.invulnerability.remove(uuid);
    }

    @EventHandler
    public void onFallDamage(EntityDamageEvent e) {
        if (this.grapplingHook.isDisabled()) {
            return;
        }
        if (e.getEntity() instanceof Player && e.getCause() == EntityDamageEvent.DamageCause.FALL && this.invulnerability.remove(e.getEntity().getUniqueId())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPortalEnter(EntityPortalEnterEvent e) {
        if (this.grapplingHook.isDisabled()) {
            return;
        }
        Entity entity = e.getEntity();
        if (entity instanceof Arrow) {
            Arrow arrow = (Arrow)entity;
            this.handleGrapplingHook(arrow);
        }
    }

    @EventHandler
    public void onLeash(PlayerLeashEntityEvent e) {
        if (this.grapplingHook.isDisabled()) {
            return;
        }
        Player p = e.getPlayer();
        ItemStack item = p.getInventory().getItemInMainHand();
        SlimefunItem slimeItem = SlimefunItem.getByItem(item);
        if (slimeItem instanceof GrapplingHook) {
            e.setCancelled(true);
        }
    }

    private void handleGrapplingHook(@Nullable Arrow arrow) {
        Player player;
        GrapplingHookEntity hook;
        ProjectileSource projectileSource;
        if (arrow != null && arrow.isValid() && (projectileSource = arrow.getShooter()) instanceof Player && (hook = this.activeHooks.get((player = (Player)projectileSource).getUniqueId())) != null) {
            Location target = arrow.getLocation();
            hook.drop(target);
            Vector velocity = new Vector(0.0, 0.2, 0.0);
            if (player.getLocation().distance(target) < 3.0) {
                if (target.getY() <= player.getLocation().getY()) {
                    velocity = target.toVector().subtract(player.getLocation().toVector());
                }
            } else {
                double d;
                Location l = player.getLocation();
                l.setY(l.getY() + 0.5);
                player.teleport(l);
                double g = -0.08;
                double t = d = target.distance(l);
                double vX = (1.0 + 0.08 * t) * (target.getX() - l.getX()) / t;
                double vY = (1.0 + 0.04 * t) * (target.getY() - l.getY()) / t - 0.5 * g * t;
                double vZ = (1.0 + 0.08 * t) * (target.getZ() - l.getZ()) / t;
                velocity = player.getVelocity();
                velocity.setX(vX);
                velocity.setY(vY);
                velocity.setZ(vZ);
            }
            player.setVelocity(velocity);
            hook.remove();
            Slimefun.runSync(() -> this.activeHooks.remove(player.getUniqueId()), 20L);
        }
    }

    public boolean isGrappling(@Nonnull UUID uuid) {
        return this.activeHooks.containsKey(uuid);
    }

    @ParametersAreNonnullByDefault
    public void addGrapplingHook(Player p, Arrow arrow, Bat bat, boolean dropItem, long despawnTicks, boolean wasConsumed) {
        GrapplingHookEntity hook = new GrapplingHookEntity(p, arrow, (Entity)bat, dropItem, wasConsumed);
        UUID uuid = p.getUniqueId();
        this.activeHooks.put(uuid, hook);
        Slimefun.runSync(() -> {
            GrapplingHookEntity entity = this.activeHooks.get(uuid);
            if (entity != null) {
                Slimefun.getBowListener().getProjectileData().remove(uuid);
                entity.remove();
                Slimefun.runSync(() -> {
                    this.activeHooks.remove(uuid);
                    this.invulnerability.remove(uuid);
                }, 20L);
            }
        }, despawnTicks);
    }
}

