/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines.accelerators;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines.accelerators.AbstractGrowthAccelerator;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.github.thebusybiscuit.slimefun4.utils.compatibility.VersionedParticle;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.ItemStackWrapper;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.block.Block;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;

public class AnimalGrowthAccelerator
extends AbstractGrowthAccelerator {
    private static final int ENERGY_CONSUMPTION = 14;
    private static final double RADIUS = 3.0;
    private static final ItemStack organicFood = ItemStackWrapper.wrap(SlimefunItems.ORGANIC_FOOD.item());

    public AnimalGrowthAccelerator(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    @Override
    public int getCapacity() {
        return 1024;
    }

    @Override
    protected void tick(Block b) {
        BlockMenu inv = BlockStorage.getInventory(b);
        for (Entity n : b.getWorld().getNearbyEntities(b.getLocation(), 3.0, 3.0, 3.0, this::isReadyToGrow)) {
            for (int slot : this.getInputSlots()) {
                if (!SlimefunUtils.isItemSimilar(inv.getItemInSlot(slot), organicFood, false, false)) continue;
                if (this.getCharge(b.getLocation()) < 14) {
                    return;
                }
                Ageable ageable = (Ageable)n;
                this.removeCharge(b.getLocation(), 14);
                inv.consumeItem(slot);
                ageable.setAge(ageable.getAge() + 2000);
                if (ageable.getAge() > 0) {
                    ageable.setAge(0);
                }
                n.getWorld().spawnParticle(VersionedParticle.HAPPY_VILLAGER, ((LivingEntity)n).getEyeLocation(), 8, (double)0.2f, (double)0.2f, (double)0.2f);
                return;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isReadyToGrow(Entity n) {
        if (!(n instanceof Ageable)) return false;
        Ageable ageable = (Ageable)n;
        if (!n.isValid()) return false;
        if (ageable.isAdult()) return false;
        return true;
    }
}

