/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.tasks.armor;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public abstract class AbstractArmorTask
implements Runnable {
    @Override
    public final void run() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!p.isValid() || p.isDead()) continue;
            PlayerProfile.get((OfflinePlayer)p, profile -> this.onPlayerTick(p, (PlayerProfile)profile));
        }
        this.onTick();
    }

    public final void schedule(@Nonnull Slimefun plugin, long tickInterval) {
        Preconditions.checkNotNull((Object)plugin, (Object)"The plugin instance cannot be null!");
        if (tickInterval < 1L) {
            tickInterval = 1L;
            plugin.getLogger().log(Level.WARNING, "The interval for {0} is misconfigured! Received {1}, expected at least 1.", new Object[]{this.getClass().getSimpleName(), tickInterval});
        }
        plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)plugin, (Runnable)this, 0L, tickInterval);
    }

    protected void onTick() {
    }

    @ParametersAreNonnullByDefault
    protected abstract void onPlayerTick(Player var1, PlayerProfile var2);
}

