/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.tools;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.api.events.ClimbingPickLaunchEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.DamageableItem;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.settings.ClimbableSurface;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.utils.compatibility.VersionedEnchantment;
import io.github.thebusybiscuit.slimefun4.utils.tags.SlimefunTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class ClimbingPick
extends SimpleSlimefunItem<ItemUseHandler>
implements DamageableItem,
RecipeDisplayItem {
    private static final double STRONG_SURFACE_DEFAULT = 1.0;
    private static final double WEAK_SURFACE_DEFAULT = 0.6;
    private static final double MAX_DISTANCE = 4.4;
    private static final double EFFICIENCY_MODIFIER = 0.125;
    private static final long COOLDOWN = 4L;
    private final ItemSetting<Boolean> dualWielding = new ItemSetting<Boolean>(this, "dual-wielding", true);
    private final ItemSetting<Boolean> damageOnUse = new ItemSetting<Boolean>(this, "damage-on-use", true);
    private final Map<Material, ClimbableSurface> surfaces = new HashMap<Material, ClimbableSurface>();
    private final Set<UUID> users = new HashSet<UUID>();

    @ParametersAreNonnullByDefault
    public ClimbingPick(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        this.addItemSetting(this.dualWielding, this.damageOnUse);
        this.addDefaultSurfaces();
    }

    protected void addDefaultSurfaces() {
        for (Material surface : SlimefunTag.CLIMBING_PICK_STRONG_SURFACES.getValues()) {
            this.addSurface(surface, 1.0);
        }
        for (Material surface : SlimefunTag.CLIMBING_PICK_WEAK_SURFACES.getValues()) {
            this.addSurface(surface, 0.6);
        }
    }

    protected void addSurface(@Nonnull Material type, double defaultValue) {
        ClimbableSurface surface = new ClimbableSurface(this, type, defaultValue);
        this.addItemSetting(surface);
        this.surfaces.put(type, surface);
    }

    public boolean isDualWieldingEnabled() {
        return this.dualWielding.getValue();
    }

    @Nonnull
    public Collection<ClimbableSurface> getClimbableSurfaces() {
        return this.surfaces.values();
    }

    public double getClimbingSpeed(@Nonnull Material type) {
        Validate.notNull(type, "The surface cannot be null");
        ClimbableSurface surface = this.surfaces.get(type);
        if (surface != null) {
            return (Double)surface.getValue();
        }
        return 0.0;
    }

    public double getClimbingSpeed(@Nonnull ItemStack item, @Nonnull Material type) {
        int efficiencyLevel;
        double speed = this.getClimbingSpeed(type);
        if (speed > 0.0 && (efficiencyLevel = item.getEnchantmentLevel(VersionedEnchantment.EFFICIENCY)) > 0) {
            speed += (double)efficiencyLevel * 0.125;
        }
        return speed;
    }

    @Override
    public ItemUseHandler getItemHandler() {
        return e -> {
            if (!e.getClickedBlock().isPresent()) {
                return;
            }
            Block block = e.getClickedBlock().get();
            Player p = e.getPlayer();
            if (p.getLocation().distanceSquared(block.getLocation().add(0.5, 0.5, 0.5)) > 4.4) {
                return;
            }
            if (this.isDualWieldingEnabled() && !this.isItem(this.getOtherHandItem(p, e.getHand()))) {
                Slimefun.getLocalization().sendMessage((CommandSender)p, "messages.climbing-pick.dual-wielding");
                return;
            }
            if (e.getClickedFace() != BlockFace.DOWN && e.getClickedFace() != BlockFace.UP) {
                this.climb(p, e.getHand(), e.getItem(), block);
            }
        };
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    private ItemStack getOtherHandItem(Player p, EquipmentSlot hand) {
        if (hand == EquipmentSlot.HAND) {
            return p.getInventory().getItemInOffHand();
        }
        return p.getInventory().getItemInMainHand();
    }

    @ParametersAreNonnullByDefault
    private void climb(Player p, EquipmentSlot hand, ItemStack item, Block block) {
        double power = this.getClimbingSpeed(item, block.getType());
        if (power > 0.05) {
            if (this.users.add(p.getUniqueId())) {
                Slimefun.runSync(() -> this.users.remove(p.getUniqueId()), 4L);
                Vector velocity = new Vector(0.0, power, 0.0);
                ClimbingPickLaunchEvent event = new ClimbingPickLaunchEvent(p, velocity, this, item, block);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    p.setVelocity(event.getVelocity());
                    p.setFallDistance(0.0f);
                    this.swing(p, block, hand, item);
                }
            }
        } else if (!this.isDualWieldingEnabled() || hand == EquipmentSlot.HAND) {
            Slimefun.getLocalization().sendMessage((CommandSender)p, "messages.climbing-pick.wrong-material");
        }
    }

    @ParametersAreNonnullByDefault
    private void swing(Player p, Block b, EquipmentSlot hand, ItemStack item) {
        if (this.isDualWieldingEnabled()) {
            if (ThreadLocalRandom.current().nextBoolean()) {
                this.damageItem(p, p.getInventory().getItemInMainHand());
                this.playAnimation(p, b, EquipmentSlot.HAND);
            } else {
                this.damageItem(p, p.getInventory().getItemInOffHand());
                this.playAnimation(p, b, EquipmentSlot.OFF_HAND);
            }
        } else {
            this.damageItem(p, item);
            this.playAnimation(p, b, hand);
        }
    }

    @Override
    public void damageItem(@Nonnull Player p, @Nullable ItemStack item) {
        if (p.getGameMode() != GameMode.CREATIVE) {
            DamageableItem.super.damageItem(p, item);
        }
    }

    @Override
    public boolean isDamageable() {
        return this.damageOnUse.getValue();
    }

    @ParametersAreNonnullByDefault
    private void playAnimation(Player p, Block b, EquipmentSlot hand) {
        MinecraftVersion version = Slimefun.getMinecraftVersion();
        if (version != MinecraftVersion.UNIT_TEST) {
            p.getWorld().playEffect(b.getLocation(), Effect.STEP_SOUND, (Object)b.getType());
            if (hand == EquipmentSlot.HAND) {
                p.swingMainHand();
            } else {
                p.swingOffHand();
            }
        }
    }

    @Override
    public List<ItemStack> getDisplayRecipes() {
        ArrayList<ItemStack> display = new ArrayList<ItemStack>();
        for (Material mat : this.surfaces.keySet()) {
            if (!mat.isItem()) continue;
            display.add(new ItemStack(mat));
        }
        return display;
    }

    @Override
    public String getLabelLocalPath() {
        return "guide.tooltips.recipes.climbing-pick";
    }
}

