/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.food;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemConsumptionHandler;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Juice
extends SimpleSlimefunItem<ItemConsumptionHandler> {
    private final List<PotionEffect> effects;

    @ParametersAreNonnullByDefault
    public Juice(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        this(itemGroup, item, recipeType, recipe, null);
    }

    @ParametersAreNonnullByDefault
    public Juice(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, @Nullable ItemStack recipeOutput) {
        super(itemGroup, item, recipeType, recipe, recipeOutput);
        ItemMeta meta = item.getItemMeta();
        if (meta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)meta;
            this.effects = potionMeta.getCustomEffects();
        } else {
            this.effects = new ArrayList<PotionEffect>();
        }
    }

    @Override
    public ItemConsumptionHandler getItemHandler() {
        return (e, p, item) -> {
            for (PotionEffect effect : this.effects) {
                if (effect.getType() != PotionEffectType.SATURATION && effect.getType() != PotionEffectType.ABSORPTION) continue;
                p.addPotionEffect(effect);
                break;
            }
            this.removeGlassBottle(p, item);
        };
    }

    @ParametersAreNonnullByDefault
    private void removeGlassBottle(Player p, ItemStack item) {
        if (SlimefunUtils.isItemSimilar(item, p.getInventory().getItemInMainHand(), true)) {
            if (p.getInventory().getItemInMainHand().getAmount() == 1) {
                p.getEquipment().getItemInMainHand().setAmount(0);
            } else {
                p.getInventory().removeItem(new ItemStack[]{new ItemStack(Material.GLASS_BOTTLE, 1)});
            }
        } else if (SlimefunUtils.isItemSimilar(item, p.getInventory().getItemInOffHand(), true)) {
            if (p.getInventory().getItemInOffHand().getAmount() == 1) {
                p.getEquipment().getItemInOffHand().setAmount(0);
            } else {
                p.getInventory().removeItem(new ItemStack[]{new ItemStack(Material.GLASS_BOTTLE, 1)});
            }
        }
    }
}

