/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.thebusybiscuit.slimefun4.core.debug.Debug;
import io.github.thebusybiscuit.slimefun4.core.debug.TestCase;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.plugin.java.JavaPlugin;

public class AnalyticsService {
    private static final int VERSION = 1;
    private static final String API_URL = "https://analytics.slimefun.dev/ingest";
    private final JavaPlugin plugin;
    private final HttpClient client = HttpClient.newHttpClient();
    private boolean enabled;

    public AnalyticsService(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void start() {
        this.enabled = Slimefun.getCfg().getBoolean("metrics.analytics");
        if (this.enabled) {
            this.plugin.getLogger().info("Enabled Analytics Service");
            Slimefun.getThreadService().newScheduledThread(this.plugin, "AnalyticsService - Timings", this.sendTimingsAnalytics(), 1L, 1L, TimeUnit.MINUTES);
        }
    }

    @Nonnull
    private Runnable sendTimingsAnalytics() {
        return () -> {
            double tickInterval = Slimefun.getTickerTask().getTickRate();
            double totalTimings = Slimefun.getProfiler().getAndResetAverageNanosecondTimings();
            double avgPerMachine = Slimefun.getProfiler().getAverageTimingsPerMachine();
            if (totalTimings == 0.0 || avgPerMachine == 0.0) {
                Debug.log(TestCase.ANALYTICS, "Ignoring analytics data for server_timings as no data was found - total: " + totalTimings + ", avg: " + avgPerMachine);
                return;
            }
            this.send("server_timings", new double[]{tickInterval, totalTimings, avgPerMachine}, null);
        };
    }

    public void recordPlayerProfileDataTime(@Nonnull String backend, boolean load, long nanoseconds) {
        this.send("player_profile_data_load_time", new double[]{nanoseconds, load ? 1.0 : 0.0}, new String[]{backend});
    }

    @ParametersAreNonnullByDefault
    private void send(String id, double[] doubles, String[] blobs) {
        if (!this.enabled || !Slimefun.getUpdater().getBranch().isOfficial() || Slimefun.instance().isUnitTest()) {
            return;
        }
        JsonObject object = new JsonObject();
        JsonArray indexes = new JsonArray();
        indexes.add(id);
        object.add("indexes", (JsonElement)indexes);
        JsonArray doublesArray = new JsonArray();
        doublesArray.add((Number)1);
        if (doubles != null) {
            for (double d : doubles) {
                doublesArray.add((Number)d);
            }
        }
        object.add("doubles", (JsonElement)doublesArray);
        JsonArray blobsArray = new JsonArray();
        blobsArray.add(Slimefun.getVersion());
        if (blobs != null) {
            for (String s : blobs) {
                blobsArray.add(s);
            }
        }
        object.add("blobs", (JsonElement)blobsArray);
        Debug.log(TestCase.ANALYTICS, "Sending analytics data for " + id);
        Debug.log(TestCase.ANALYTICS, object.toString());
        this.client.sendAsync(HttpRequest.newBuilder().uri(URI.create(API_URL)).header("User-Agent", "Mozilla/5.0 Slimefun4 AnalyticsService").POST(HttpRequest.BodyPublishers.ofString(object.toString())).build(), HttpResponse.BodyHandlers.discarding()).thenAcceptAsync(res -> {
            if (res.statusCode() == 200) {
                Debug.log(TestCase.ANALYTICS, "Analytics data for " + id + " sent successfully");
            } else {
                Debug.log(TestCase.ANALYTICS, "Analytics data for " + id + " failed to send - " + res.statusCode());
            }
        });
    }
}

