/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerBackpack;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundEffect;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.backpacks.SlimefunBackpack;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.SoundCategory;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class BackpackListener
implements Listener {
    private final Map<UUID, ItemStack> backpacks = new HashMap<UUID, ItemStack>();

    public void register(@Nonnull Slimefun plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onClose(InventoryCloseEvent e) {
        Player p = (Player)e.getPlayer();
        if (this.markBackpackDirty(p)) {
            SoundEffect.BACKPACK_CLOSE_SOUND.playFor(p);
        }
    }

    private boolean markBackpackDirty(@Nonnull Player p) {
        ItemStack backpack = this.backpacks.remove(p.getUniqueId());
        if (backpack != null) {
            PlayerProfile.getBackpack(backpack, PlayerBackpack::markDirty);
            return true;
        }
        return false;
    }

    @EventHandler
    public void onItemDrop(PlayerDropItemEvent e) {
        ItemStack item;
        SlimefunItem sfItem;
        if (this.backpacks.containsKey(e.getPlayer().getUniqueId()) && (sfItem = SlimefunItem.getByItem(item = e.getItemDrop().getItemStack())) instanceof SlimefunBackpack) {
            e.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onClick(InventoryClickEvent e) {
        SlimefunItem backpack;
        ItemStack item = this.backpacks.get(e.getWhoClicked().getUniqueId());
        if (item != null && (backpack = SlimefunItem.getByItem(item)) instanceof SlimefunBackpack) {
            SlimefunBackpack slimefunBackpack = (SlimefunBackpack)backpack;
            if (e.getClick() == ClickType.NUMBER_KEY) {
                ItemStack hotbarItem;
                if (e.getClickedInventory().getType() != InventoryType.PLAYER && !this.isAllowed(slimefunBackpack, hotbarItem = e.getWhoClicked().getInventory().getItem(e.getHotbarButton()))) {
                    e.setCancelled(true);
                }
            } else if (e.getClick() == ClickType.SWAP_OFFHAND) {
                if (e.getClickedInventory().getType() != InventoryType.PLAYER) {
                    ItemStack offHandItem = e.getWhoClicked().getInventory().getItemInOffHand();
                    if (!this.isAllowed(slimefunBackpack, offHandItem)) {
                        e.setCancelled(true);
                    }
                } else if (e.getCurrentItem() != null && e.getCurrentItem().isSimilar(item)) {
                    e.setCancelled(true);
                }
            } else if (!this.isAllowed(slimefunBackpack, e.getCurrentItem())) {
                e.setCancelled(true);
            }
        }
    }

    private boolean isAllowed(@Nonnull SlimefunBackpack backpack, @Nullable ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return true;
        }
        return backpack.isItemAllowed(item, SlimefunItem.getByItem(item));
    }

    @ParametersAreNonnullByDefault
    public void openBackpack(Player p, ItemStack item, SlimefunBackpack backpack) {
        if (item.getAmount() == 1) {
            if (backpack.canUse(p, true) && !PlayerProfile.get((OfflinePlayer)p, profile -> this.openBackpack(p, item, (PlayerProfile)profile, backpack.getSize()))) {
                Slimefun.getLocalization().sendMessage((CommandSender)p, "messages.opening-backpack");
            }
        } else {
            Slimefun.getLocalization().sendMessage((CommandSender)p, "backpack.no-stack", true);
        }
    }

    @ParametersAreNonnullByDefault
    private void openBackpack(Player p, ItemStack item, PlayerProfile profile, int size) {
        List lore = item.getItemMeta().getLore();
        for (int line = 0; line < lore.size(); ++line) {
            if (!((String)lore.get(line)).equals(String.valueOf(ChatColor.GRAY) + "ID: <ID>")) continue;
            this.setBackpackId((OfflinePlayer)p, item, line, profile.createBackpack(size).getId());
            break;
        }
        if (this.markBackpackDirty(p)) {
            p.closeInventory();
        }
        if (!this.backpacks.containsValue(item)) {
            SoundEffect.BACKPACK_OPEN_SOUND.playAt(p.getLocation(), SoundCategory.PLAYERS);
            this.backpacks.put(p.getUniqueId(), item);
            PlayerProfile.getBackpack(item, backpack -> {
                if (backpack != null) {
                    backpack.open(p);
                }
            });
        } else {
            Slimefun.getLocalization().sendMessage((CommandSender)p, "backpack.already-open", true);
        }
    }

    public void setBackpackId(@Nonnull OfflinePlayer backpackOwner, @Nonnull ItemStack item, int line, int id) {
        Validate.notNull(backpackOwner, "Backpacks must have an owner!");
        Validate.notNull(item, "Cannot set the id onto null!");
        ItemMeta im = item.getItemMeta();
        if (!im.hasLore()) {
            throw new IllegalArgumentException("This backpack does not have any lore!");
        }
        List lore = im.getLore();
        if (line >= lore.size() || !((String)lore.get(line)).contains("<ID>")) {
            throw new IllegalArgumentException("Specified a line that is out of bounds or invalid!");
        }
        lore.set(line, ((String)lore.get(line)).replace("<ID>", String.valueOf(backpackOwner.getUniqueId()) + "#" + id));
        im.setLore(lore);
        item.setItemMeta(im);
    }
}

