/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.androids;

import io.github.thebusybiscuit.slimefun4.api.events.AndroidFarmEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.items.androids.AndroidInstance;
import io.github.thebusybiscuit.slimefun4.implementation.items.androids.AndroidType;
import io.github.thebusybiscuit.slimefun4.implementation.items.androids.ProgrammableAndroid;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class FarmerAndroid
extends ProgrammableAndroid {
    @ParametersAreNonnullByDefault
    public FarmerAndroid(ItemGroup itemGroup, int tier, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, tier, item, recipeType, recipe);
    }

    @Override
    public AndroidType getAndroidType() {
        return this.getTier() == 1 ? AndroidType.FARMER : AndroidType.ADVANCED_FARMER;
    }

    @Override
    protected void farm(Block b, BlockMenu menu, Block block, boolean isAdvanced) {
        Ageable ageable;
        Material blockType = block.getType();
        BlockData data = block.getBlockData();
        ItemStack drop = null;
        if (!block.getWorld().getWorldBorder().isInside(block.getLocation())) {
            return;
        }
        if (data instanceof Ageable && (ageable = (Ageable)data).getAge() >= ageable.getMaximumAge()) {
            drop = this.getDropFromCrop(blockType);
        }
        AndroidInstance instance = new AndroidInstance(this, b);
        AndroidFarmEvent event = new AndroidFarmEvent(block, instance, isAdvanced, drop);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled() && (drop = event.getDrop()) != null && menu.pushItem(drop, this.getOutputSlots()) == null) {
            block.getWorld().playEffect(block.getLocation(), Effect.STEP_SOUND, (Object)blockType);
            if (data instanceof Ageable) {
                Ageable ageable2 = (Ageable)data;
                ageable2.setAge(0);
                block.setBlockData(data);
            }
        }
    }

    private ItemStack getDropFromCrop(Material crop) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        return switch (crop) {
            case Material.WHEAT -> new ItemStack(Material.WHEAT, ((Random)random).nextInt(2) + 1);
            case Material.POTATOES -> new ItemStack(Material.POTATO, ((Random)random).nextInt(3) + 1);
            case Material.CARROTS -> new ItemStack(Material.CARROT, ((Random)random).nextInt(3) + 1);
            case Material.BEETROOTS -> new ItemStack(Material.BEETROOT, ((Random)random).nextInt(3) + 1);
            case Material.COCOA -> new ItemStack(Material.COCOA_BEANS, ((Random)random).nextInt(3) + 1);
            case Material.NETHER_WART -> new ItemStack(Material.NETHER_WART, ((Random)random).nextInt(3) + 1);
            case Material.SWEET_BERRY_BUSH -> new ItemStack(Material.SWEET_BERRIES, ((Random)random).nextInt(3) + 1);
            default -> null;
        };
    }
}

