/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.github;

import io.github.thebusybiscuit.slimefun4.core.services.github.ContributionsConnector;
import io.github.thebusybiscuit.slimefun4.core.services.github.Contributor;
import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubConnector;
import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubService;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.skins.PlayerSkin;
import io.github.thebusybiscuit.slimefun4.libraries.dough.skins.UUIDLookup;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

class GitHubTask
implements Runnable {
    private static final int MAX_REQUESTS_PER_MINUTE = 16;
    private final GitHubService gitHubService;

    GitHubTask(@Nonnull GitHubService github) {
        this.gitHubService = github;
    }

    @Override
    public void run() {
        if (Bukkit.isPrimaryThread()) {
            Slimefun.logger().log(Level.SEVERE, "The contributors task may never run on the main Thread!");
            return;
        }
        this.connectAndCache();
        this.grabTextures();
    }

    private void connectAndCache() {
        this.gitHubService.getConnectors().forEach(GitHubConnector::download);
    }

    private void grabTextures() {
        Contributor contributor;
        int newRequests;
        HashMap<String, String> skins = new HashMap<String, String>();
        int requests = 0;
        Iterator<Object> iterator = this.gitHubService.getContributors().values().iterator();
        while (iterator.hasNext() && (newRequests = this.requestTexture(contributor = (Contributor)iterator.next(), skins)) >= 0 && (requests += newRequests) < 16) {
        }
        if (requests >= 16 && Slimefun.instance() != null && Slimefun.instance().isEnabled()) {
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)Slimefun.instance(), this::grabTextures, 2400L);
        }
        for (GitHubConnector connector : this.gitHubService.getConnectors()) {
            ContributionsConnector contributionsConnector;
            if (!(connector instanceof ContributionsConnector) || (contributionsConnector = (ContributionsConnector)connector).hasFinished()) continue;
            return;
        }
        this.gitHubService.saveCache();
    }

    private int requestTexture(@Nonnull Contributor contributor, @Nonnull Map<String, String> skins) {
        if (!contributor.hasTexture()) {
            try {
                if (!skins.containsKey(contributor.getMinecraftName())) {
                    contributor.setTexture(this.pullTexture(contributor, skins));
                    return contributor.getUniqueId().isPresent() ? 1 : 2;
                }
                contributor.setTexture(skins.get(contributor.getMinecraftName()));
            }
            catch (IllegalArgumentException x) {
                contributor.setTexture(null);
            }
            catch (InterruptedException x) {
                Slimefun.logger().log(Level.WARNING, "The contributors thread was interrupted!");
                Thread.currentThread().interrupt();
            }
            catch (Exception x) {
                Slimefun.logger().log(Level.WARNING, "Attempted to refresh skin cache, got this response: {0}: {1}", new Object[]{x.getClass().getSimpleName(), x.getMessage()});
                Slimefun.logger().log(Level.WARNING, "This usually means mojang.com is temporarily down or started to rate-limit this connection, nothing to worry about!");
                String msg = x.getMessage();
                if (msg != null && msg.contains("429")) {
                    Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)Slimefun.instance(), this::grabTextures, 6000L);
                }
                return -1;
            }
        }
        return 0;
    }

    @Nullable
    private String pullTexture(@Nonnull Contributor contributor, @Nonnull Map<String, String> skins) throws InterruptedException, ExecutionException, TimeoutException {
        CompletableFuture<Object> future;
        Optional<UUID> uuid = contributor.getUniqueId();
        if (!uuid.isPresent()) {
            future = UUIDLookup.getUuidFromUsername((Plugin)Slimefun.instance(), contributor.getMinecraftName());
            uuid = Optional.ofNullable(future.get(30L, TimeUnit.SECONDS));
            uuid.ifPresent(contributor::setUniqueId);
        }
        if (uuid.isPresent()) {
            future = PlayerSkin.fromPlayerUUID((Plugin)Slimefun.instance(), uuid.get());
            Optional<String> skin = Optional.of(((PlayerSkin)future.get()).getProfile().getBase64Texture());
            skins.put(contributor.getMinecraftName(), skin.orElse(""));
            return skin.orElse(null);
        }
        return null;
    }
}

