/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.player;

import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.config.Config;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class PlayerBackpack {
    private static final String CONFIG_PREFIX = "backpacks.";
    private final UUID ownerId;
    private final int id;
    @Deprecated
    private PlayerProfile profile;
    @Deprecated
    private Config cfg;
    private Inventory inventory;
    private int size;

    private PlayerBackpack(@Nonnull UUID ownerId, int id, int size) {
        this.ownerId = ownerId;
        this.id = id;
        this.size = size;
    }

    @Deprecated
    public PlayerBackpack(@Nonnull PlayerProfile profile, int id) {
        this(profile, id, profile.getConfig().getInt(CONFIG_PREFIX + id + ".size"));
        for (int i = 0; i < this.size; ++i) {
            this.inventory.setItem(i, this.cfg.getItem(CONFIG_PREFIX + id + ".contents." + i));
        }
    }

    @Deprecated
    public PlayerBackpack(@Nonnull PlayerProfile profile, int id, int size) {
        if (size < 9 || size > 54 || size % 9 != 0) {
            throw new IllegalArgumentException("Invalid size! Size must be one of: [9, 18, 27, 36, 45, 54]");
        }
        this.ownerId = profile.getUUID();
        this.profile = profile;
        this.id = id;
        this.cfg = profile.getConfig();
        this.size = size;
        this.cfg.setValue(CONFIG_PREFIX + id + ".size", size);
        this.markDirty();
        this.inventory = Bukkit.createInventory(null, (int)size, (String)("Backpack [" + size + " Slots]"));
    }

    public int getId() {
        return this.id;
    }

    @Deprecated
    @Nonnull
    public PlayerProfile getOwner() {
        return this.profile != null ? this.profile : (PlayerProfile)PlayerProfile.find(Bukkit.getOfflinePlayer((UUID)this.ownerId)).orElse(null);
    }

    public UUID getOwnerId() {
        return this.ownerId;
    }

    public int getSize() {
        return this.size;
    }

    @Nonnull
    public Inventory getInventory() {
        return this.inventory;
    }

    public void open(Player ... players) {
        Slimefun.runSync(() -> {
            for (Player p : players) {
                p.openInventory(this.inventory);
            }
        });
    }

    public CompletableFuture<Void> closeForAll() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Slimefun.runSync(() -> {
            Iterator iterator = new ArrayList(this.inventory.getViewers()).iterator();
            while (iterator.hasNext()) {
                ((HumanEntity)iterator.next()).closeInventory();
            }
            future.complete(null);
        });
        return future;
    }

    public void setSize(int size) {
        if (size < 9 || size > 54 || size % 9 != 0) {
            throw new IllegalArgumentException("Invalid size! Size must be one of: [9, 18, 27, 36, 45, 54]");
        }
        this.size = size;
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)("Backpack [" + size + " Slots]"));
        for (int slot = 0; slot < this.inventory.getSize(); ++slot) {
            inv.setItem(slot, this.inventory.getItem(slot));
        }
        this.inventory = inv;
        this.markDirty();
    }

    @Deprecated
    public void save() {
        for (int i = 0; i < this.size; ++i) {
            this.cfg.setValue(CONFIG_PREFIX + this.id + ".contents." + i, this.inventory.getItem(i));
        }
    }

    public void markDirty() {
        if (this.profile != null) {
            this.profile.markDirty();
        }
    }

    private void setContents(int size, HashMap<Integer, ItemStack> contents) {
        if (this.inventory == null) {
            this.inventory = Bukkit.createInventory(null, (int)size, (String)("Backpack [" + size + " Slots]"));
        }
        for (int i = 0; i < size; ++i) {
            this.inventory.setItem(i, contents.get(i));
        }
    }

    @ParametersAreNonnullByDefault
    public static PlayerBackpack load(UUID ownerId, int id, int size, HashMap<Integer, ItemStack> contents) {
        PlayerBackpack backpack = new PlayerBackpack(ownerId, id, size);
        backpack.setContents(size, contents);
        return backpack;
    }

    @ParametersAreNonnullByDefault
    public static PlayerBackpack newBackpack(UUID ownerId, int id, int size) {
        if (size < 9 || size > 54 || size % 9 != 0) {
            throw new IllegalArgumentException("Invalid size! Size must be one of: [9, 18, 27, 36, 45, 54]");
        }
        PlayerBackpack backpack = new PlayerBackpack(ownerId, id, size);
        backpack.setContents(size, new HashMap<Integer, ItemStack>());
        return backpack;
    }
}

