/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.guide.options;

import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuide;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.core.guide.options.ContributorsMenu;
import io.github.thebusybiscuit.slimefun4.core.guide.options.FireworksOption;
import io.github.thebusybiscuit.slimefun4.core.guide.options.GuideModeOption;
import io.github.thebusybiscuit.slimefun4.core.guide.options.LearningAnimationOption;
import io.github.thebusybiscuit.slimefun4.core.guide.options.PlayerLanguageOption;
import io.github.thebusybiscuit.slimefun4.core.guide.options.SlimefunGuideOption;
import io.github.thebusybiscuit.slimefun4.core.services.LocalizationService;
import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubService;
import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundEffect;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class SlimefunGuideSettings {
    private static final int[] BACKGROUND_SLOTS = new int[]{1, 3, 5, 7, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 26, 27, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 48, 50, 52, 53};
    private static final List<SlimefunGuideOption<?>> options = new ArrayList();

    private SlimefunGuideSettings() {
    }

    public static <T> void addOption(@Nonnull SlimefunGuideOption<T> option) {
        options.add(option);
    }

    @ParametersAreNonnullByDefault
    public static void openSettings(Player p, ItemStack guide) {
        ChestMenu menu = new ChestMenu(Slimefun.getLocalization().getMessage(p, "guide.title.settings"));
        menu.setEmptySlotsClickable(false);
        menu.addMenuOpeningHandler(SoundEffect.GUIDE_OPEN_SETTING_SOUND::playFor);
        ChestMenuUtils.drawBackground(menu, BACKGROUND_SLOTS);
        SlimefunGuideSettings.addHeader(p, menu, guide);
        SlimefunGuideSettings.addConfigurableOptions(p, menu, guide);
        menu.open(p);
    }

    @ParametersAreNonnullByDefault
    private static void addHeader(Player p, ChestMenu menu, ItemStack guide) {
        LocalizationService locale = Slimefun.getLocalization();
        menu.addItem(0, CustomItemStack.create(SlimefunGuide.getItem(SlimefunGuideMode.SURVIVAL_MODE), "&e\u21e6 " + locale.getMessage(p, "guide.back.title"), "", "&7" + locale.getMessage(p, "guide.back.guide")));
        menu.addMenuClickHandler(0, (pl, slot, item, action) -> {
            SlimefunGuide.openGuide(pl, guide);
            return false;
        });
        GitHubService github = Slimefun.getGitHubService();
        ArrayList<Object> contributorsLore = new ArrayList<Object>();
        contributorsLore.add("");
        contributorsLore.addAll(locale.getMessages(p, "guide.credits.description", msg -> msg.replace("%contributors%", String.valueOf(github.getContributors().size()))));
        contributorsLore.add("");
        contributorsLore.add("&7\u21e8 &e" + locale.getMessage(p, "guide.credits.open"));
        menu.addItem(2, CustomItemStack.create(SlimefunUtils.getCustomHead("e952d2b3f351a6b0487cc59db31bf5f2641133e5ba0006b18576e996a0293e52"), "&c" + locale.getMessage(p, "guide.title.credits"), contributorsLore.toArray(new String[0])));
        menu.addMenuClickHandler(2, (pl, slot, action, item) -> {
            ContributorsMenu.open(pl, 0);
            return false;
        });
        menu.addItem(4, CustomItemStack.create(Material.WRITABLE_BOOK, String.valueOf(ChatColor.GREEN) + locale.getMessage(p, "guide.title.versions"), "&7&o" + locale.getMessage(p, "guide.tooltips.versions-notice"), "", "&fMinecraft: &a" + Bukkit.getBukkitVersion(), "&fSlimefun: &a" + Slimefun.getVersion()), ChestMenuUtils.getEmptyClickHandler());
        menu.addItem(6, CustomItemStack.create(Material.COMPARATOR, "&e" + locale.getMessage(p, "guide.title.source"), "", "&7Last Activity: &a" + NumberUtils.getElapsedTime(github.getLastUpdate()) + " ago", "&7Forks: &e" + github.getForks(), "&7Stars: &e" + github.getStars(), "", "&7&oSlimefun 4 is a community project,", "&7&othe source code is available on GitHub", "&7&oand if you want to keep this Plugin alive,", "&7&othen please consider contributing to it", "", "&7\u21e8 &eClick to go to GitHub"));
        menu.addMenuClickHandler(6, (pl, slot, item, action) -> {
            pl.closeInventory();
            ChatUtils.sendURL((CommandSender)pl, "https://github.com/Slimefun/Slimefun4");
            return false;
        });
        menu.addItem(8, CustomItemStack.create(Material.KNOWLEDGE_BOOK, "&3" + locale.getMessage(p, "guide.title.wiki"), "", "&7Do you need help with an Item or machine?", "&7You cannot figure out what to do?", "&7Check out our community-maintained Wiki", "&7and become one of our Editors!", "", "&7\u21e8 &eClick to go to the official Slimefun Wiki"));
        menu.addMenuClickHandler(8, (pl, slot, item, action) -> {
            pl.closeInventory();
            ChatUtils.sendURL((CommandSender)pl, "https://github.com/Slimefun/Slimefun4/wiki");
            return false;
        });
        menu.addItem(47, CustomItemStack.create(Material.BOOKSHELF, "&3" + locale.getMessage(p, "guide.title.addons"), "", "&7Slimefun is huge. But its addons are what makes", "&7this plugin truly shine. Go check them out, some", "&7of them may be exactly what you were missing out on!", "", "&7Installed on this Server: &b" + Slimefun.getInstalledAddons().size(), "", "&7\u21e8 &eClick to see all available addons for Slimefun4"));
        menu.addMenuClickHandler(47, (pl, slot, item, action) -> {
            pl.closeInventory();
            ChatUtils.sendURL((CommandSender)pl, "https://github.com/Slimefun/Slimefun4/wiki/Addons");
            return false;
        });
        if (Slimefun.getUpdater().getBranch().isOfficial()) {
            menu.addItem(49, CustomItemStack.create(Material.REDSTONE_TORCH, "&4" + locale.getMessage(p, "guide.title.bugs"), "", "&7&oBug reports have to be made in English!", "", "&7Open Issues: &a" + github.getOpenIssues(), "&7Pending Pull Requests: &a" + github.getPendingPullRequests(), "", "&7\u21e8 &eClick to go to the Slimefun4 Bug Tracker"));
            menu.addMenuClickHandler(49, (pl, slot, item, action) -> {
                pl.closeInventory();
                ChatUtils.sendURL((CommandSender)pl, "https://github.com/Slimefun/Slimefun4/issues");
                return false;
            });
        } else {
            menu.addItem(49, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        menu.addItem(51, CustomItemStack.create(Material.TOTEM_OF_UNDYING, String.valueOf(ChatColor.RED) + locale.getMessage(p, "guide.work-in-progress"), new String[0]), (pl, slot, item, action) -> false);
    }

    @ParametersAreNonnullByDefault
    private static void addConfigurableOptions(Player p, ChestMenu menu, ItemStack guide) {
        int i = 19;
        for (SlimefunGuideOption<?> option : options) {
            Optional<ItemStack> item = option.getDisplayItem(p, guide);
            if (!item.isPresent()) continue;
            menu.addItem(i, item.get());
            menu.addMenuClickHandler(i, (pl, slot, stack, action) -> {
                option.onClick(p, guide);
                return false;
            });
            ++i;
        }
    }

    public static boolean hasFireworksEnabled(@Nonnull Player p) {
        return SlimefunGuideSettings.getOptionValue(p, FireworksOption.class, true);
    }

    public static boolean hasLearningAnimationEnabled(@Nonnull Player p) {
        return SlimefunGuideSettings.getOptionValue(p, LearningAnimationOption.class, true);
    }

    @Nonnull
    private static <T extends SlimefunGuideOption<V>, V> V getOptionValue(@Nonnull Player p, @Nonnull Class<T> optionsClass, @Nonnull V defaultValue) {
        for (SlimefunGuideOption<?> option : options) {
            if (!optionsClass.isInstance(option)) continue;
            SlimefunGuideOption o = (SlimefunGuideOption)optionsClass.cast(option);
            ItemStack guide = SlimefunGuide.getItem(SlimefunGuideMode.SURVIVAL_MODE);
            return (V)o.getSelectedOption(p, guide).orElse(defaultValue);
        }
        return defaultValue;
    }

    static {
        options.add(new GuideModeOption());
        options.add(new FireworksOption());
        options.add(new LearningAnimationOption());
        options.add(new PlayerLanguageOption());
    }
}

