/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.dough.items;

import io.github.thebusybiscuit.slimefun4.libraries.dough.items.nms.ItemNameAdapter;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;

public final class ItemUtils {
    private static final ItemNameAdapter adapter = ItemNameAdapter.get();

    private ItemUtils() {
    }

    @Nonnull
    public static String getItemName(@Nullable ItemStack item) {
        ItemMeta meta;
        if (item == null) {
            return "null";
        }
        if (item.hasItemMeta() && (meta = item.getItemMeta()).hasDisplayName()) {
            return meta.getDisplayName();
        }
        if (adapter != null) {
            try {
                return adapter.getName(item);
            }
            catch (Exception e) {
                e.printStackTrace();
                return "ERROR";
            }
        }
        return "unknown";
    }

    public static boolean canStack(@Nullable ItemStack a, @Nullable ItemStack b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.getType() != b.getType() || a.hasItemMeta() != b.hasItemMeta()) {
            return false;
        }
        if (a.hasItemMeta()) {
            ItemMeta bMeta;
            ItemMeta aMeta = a.getItemMeta();
            if (aMeta instanceof Damageable != (bMeta = b.getItemMeta()) instanceof Damageable) {
                return false;
            }
            if (aMeta instanceof Damageable && ((Damageable)aMeta).getDamage() != ((Damageable)bMeta).getDamage()) {
                return false;
            }
            if (aMeta instanceof LeatherArmorMeta != bMeta instanceof LeatherArmorMeta) {
                return false;
            }
            if (aMeta instanceof LeatherArmorMeta && !((LeatherArmorMeta)aMeta).getColor().equals((Object)((LeatherArmorMeta)bMeta).getColor())) {
                return false;
            }
            if (aMeta.hasCustomModelData() != bMeta.hasCustomModelData()) {
                return false;
            }
            if (aMeta.hasCustomModelData() && aMeta.getCustomModelData() != bMeta.getCustomModelData()) {
                return false;
            }
            if (!aMeta.getEnchants().equals(bMeta.getEnchants())) {
                return false;
            }
            if (aMeta.hasDisplayName() != bMeta.hasDisplayName()) {
                return false;
            }
            if (aMeta.hasDisplayName() && !aMeta.getDisplayName().equals(bMeta.getDisplayName())) {
                return false;
            }
            if (aMeta.hasLore() != bMeta.hasLore()) {
                return false;
            }
            if (aMeta.hasLore()) {
                List aLore = aMeta.getLore();
                List bLore = bMeta.getLore();
                if (aLore.size() != bLore.size()) {
                    return false;
                }
                for (int i = 0; i < aLore.size(); ++i) {
                    if (((String)aLore.get(i)).equals(bLore.get(i))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static void damageItem(@Nonnull ItemStack item, boolean ignoreEnchantments) {
        ItemUtils.damageItem(item, 1, ignoreEnchantments);
    }

    public static void damageItem(@Nonnull ItemStack item, int damage, boolean ignoreEnchantments) {
        if (item.getType() != Material.AIR && item.getAmount() > 0) {
            ItemMeta meta;
            Damageable damageable;
            int remove = damage;
            if (!ignoreEnchantments && item.getEnchantments().containsKey(Registry.ENCHANTMENT.get(NamespacedKey.minecraft((String)"unbreaking")))) {
                int level = item.getEnchantmentLevel((Enchantment)Registry.ENCHANTMENT.get(NamespacedKey.minecraft((String)"unbreaking")));
                for (int i = 0; i < damage; ++i) {
                    if (!(Math.random() * 100.0 <= (double)(60 + Math.floorDiv(40, level + 1)))) continue;
                    --remove;
                }
            }
            if ((damageable = (Damageable)(meta = item.getItemMeta())).getDamage() + remove > item.getType().getMaxDurability()) {
                item.setAmount(0);
            } else {
                damageable.setDamage(damageable.getDamage() + remove);
                item.setItemMeta(meta);
            }
        }
    }

    public static void consumeItem(@Nonnull ItemStack item, boolean replaceConsumables) {
        ItemUtils.consumeItem(item, 1, replaceConsumables);
    }

    public static void consumeItem(@Nonnull ItemStack item, int amount, boolean replaceConsumables) {
        if (item.getType() != Material.AIR && item.getAmount() > 0) {
            if (replaceConsumables) {
                switch (item.getType()) {
                    case POTION: 
                    case DRAGON_BREATH: 
                    case HONEY_BOTTLE: {
                        item.setType(Material.GLASS_BOTTLE);
                        item.setAmount(1);
                        return;
                    }
                    case WATER_BUCKET: 
                    case LAVA_BUCKET: 
                    case MILK_BUCKET: {
                        item.setType(Material.BUCKET);
                        item.setAmount(1);
                        return;
                    }
                }
            }
            if (item.getAmount() <= amount) {
                item.setAmount(0);
            } else {
                item.setAmount(item.getAmount() - amount);
            }
        }
    }
}

