/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.utils;

import io.github.thebusybiscuit.slimefun4.utils.compatibility.VersionedEntityType;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.inventory.meta.FireworkMeta;

public final class FireworkUtils {
    private static final Color[] COLORS = new Color[]{Color.AQUA, Color.BLACK, Color.BLUE, Color.FUCHSIA, Color.GRAY, Color.GREEN, Color.LIME, Color.MAROON, Color.NAVY, Color.OLIVE, Color.ORANGE, Color.PURPLE, Color.RED, Color.SILVER, Color.TEAL, Color.WHITE, Color.YELLOW};
    private static final EntityType firework = VersionedEntityType.FIREWORK;

    private FireworkUtils() {
    }

    public static void launchFirework(@Nonnull Location l, @Nonnull Color color) {
        FireworkUtils.createFirework(l, color);
    }

    @Nonnull
    public static Firework createFirework(@Nonnull Location l, @Nonnull Color color) {
        Firework fw = (Firework)l.getWorld().spawnEntity(l, firework);
        FireworkMeta meta = fw.getFireworkMeta();
        meta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Slimefun Research");
        FireworkEffect effect = FireworkUtils.getRandomEffect(ThreadLocalRandom.current(), color);
        meta.addEffect(effect);
        meta.setPower(ThreadLocalRandom.current().nextInt(2) + 1);
        fw.setFireworkMeta(meta);
        return fw;
    }

    public static void launchRandom(@Nonnull Entity n, int amount) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < amount; ++i) {
            Location l = n.getLocation().clone();
            l.setX(l.getX() + (double)((Random)random).nextInt(amount * 2) - (double)amount);
            l.setZ(l.getZ() + (double)((Random)random).nextInt(amount * 2) - (double)amount);
            FireworkUtils.launchFirework(l, FireworkUtils.getRandomColor());
        }
    }

    @Nonnull
    public static FireworkEffect getRandomEffect(@Nonnull Random random, @Nonnull Color color) {
        return FireworkEffect.builder().flicker(random.nextBoolean()).withColor(color).with(random.nextBoolean() ? FireworkEffect.Type.BALL : FireworkEffect.Type.BALL_LARGE).trail(random.nextBoolean()).build();
    }

    @Nonnull
    private static Color getRandomColor() {
        return COLORS[ThreadLocalRandom.current().nextInt(COLORS.length)];
    }
}

