/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.tasks.armor;

import io.github.thebusybiscuit.slimefun4.api.events.RadiationDamageEvent;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.attributes.ProtectionType;
import io.github.thebusybiscuit.slimefun4.core.attributes.RadiationSymptom;
import io.github.thebusybiscuit.slimefun4.core.attributes.Radioactive;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.armor.AbstractArmorTask;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import io.github.thebusybiscuit.slimefun4.utils.RadiationUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class RadiationTask
extends AbstractArmorTask {
    private static final int GRACE_PERIOD_DURATION = Slimefun.getCfg().getInt("options.radiation-grace-period");
    private static final Map<UUID, Long> ACTIVE_GRACE_PERIODS = new HashMap<UUID, Long>();
    private final RadiationSymptom[] symptoms = RadiationSymptom.values();

    @Override
    @ParametersAreNonnullByDefault
    protected void onPlayerTick(Player p, PlayerProfile profile) {
        if (this.withinGracePeriod(p)) {
            return;
        }
        int exposureTotal = 0;
        if (!profile.hasFullProtectionAgainst(ProtectionType.RADIATION) && p.getGameMode() != GameMode.CREATIVE && p.getGameMode() != GameMode.SPECTATOR) {
            for (ItemStack item : p.getInventory()) {
                SlimefunItem sfItem;
                if (item == null || item.getType().isAir() || !((sfItem = SlimefunItem.getByItem(item)) instanceof Radioactive)) continue;
                Radioactive radioactiveItem = (Radioactive)((Object)sfItem);
                exposureTotal += item.getAmount() * radioactiveItem.getRadioactivity().getExposureModifier();
            }
            int exposureLevelBefore = RadiationUtils.getExposure(p);
            if (exposureTotal > 0) {
                if (exposureLevelBefore == 0) {
                    Slimefun.getLocalization().sendMessage((CommandSender)p, "messages.radiation");
                }
                RadiationUtils.addExposure(p, exposureTotal);
            } else if (exposureLevelBefore > 0) {
                RadiationUtils.removeExposure(p, 1);
            }
            int exposureLevelAfter = RadiationUtils.getExposure(p);
            Slimefun.runSync(() -> {
                RadiationDamageEvent event = new RadiationDamageEvent(p, exposureLevelAfter);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                for (RadiationSymptom symptom : this.symptoms) {
                    if (!symptom.shouldApply(exposureLevelAfter)) continue;
                    symptom.apply(p);
                }
            });
            if (exposureLevelAfter > 0 || exposureLevelBefore > 0) {
                String msg = Slimefun.getLocalization().getMessage(p, "actionbar.radiation").replace("%level%", "" + exposureLevelAfter);
                BaseComponent[] components = new ComponentBuilder().append(ChatColors.color(msg)).create();
                p.spigot().sendMessage(ChatMessageType.ACTION_BAR, components);
            }
        } else {
            RadiationUtils.removeExposure(p, 1);
        }
    }

    private boolean withinGracePeriod(@Nonnull Player player) {
        Long gracePeriodEnd = ACTIVE_GRACE_PERIODS.get(player.getUniqueId());
        if (gracePeriodEnd == null) {
            return false;
        }
        if (gracePeriodEnd >= System.currentTimeMillis()) {
            return true;
        }
        ACTIVE_GRACE_PERIODS.remove(player.getUniqueId());
        return false;
    }

    public static void addGracePeriod(@Nonnull Player player) {
        ACTIVE_GRACE_PERIODS.put(player.getUniqueId(), System.currentTimeMillis() + (long)GRACE_PERIOD_DURATION * 1000L);
    }
}

