/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.weapons;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.items.settings.IntRangeSetting;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.EntityKillHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class SwordOfBeheading
extends SimpleSlimefunItem<EntityKillHandler> {
    private final ItemSetting<Integer> chanceZombie = new IntRangeSetting(this, "chance.ZOMBIE", 0, 40, 100);
    private final ItemSetting<Integer> chanceSkeleton = new IntRangeSetting(this, "chance.SKELETON", 0, 40, 100);
    private final ItemSetting<Integer> chanceWitherSkeleton = new IntRangeSetting(this, "chance.WITHER_SKELETON", 0, 25, 100);
    private final ItemSetting<Integer> chanceCreeper = new IntRangeSetting(this, "chance.CREEPER", 0, 40, 100);
    private final ItemSetting<Integer> chancePiglin = new IntRangeSetting(this, "chance.PIGLIN", 0, 40, 100);
    private final ItemSetting<Integer> chancePlayer = new IntRangeSetting(this, "chance.PLAYER", 0, 70, 100);

    @ParametersAreNonnullByDefault
    public SwordOfBeheading(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        this.addItemSetting(this.chanceZombie, this.chanceSkeleton, this.chanceWitherSkeleton, this.chanceCreeper, this.chancePiglin, this.chancePlayer);
    }

    @Override
    public EntityKillHandler getItemHandler() {
        return (e, entity, killer, item) -> {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            switch (e.getEntityType()) {
                case ZOMBIE: {
                    if (((Random)random).nextInt(100) >= this.chanceZombie.getValue()) break;
                    e.getDrops().add(new ItemStack(Material.ZOMBIE_HEAD));
                    break;
                }
                case SKELETON: {
                    if (((Random)random).nextInt(100) >= this.chanceSkeleton.getValue()) break;
                    e.getDrops().add(new ItemStack(Material.SKELETON_SKULL));
                    break;
                }
                case CREEPER: {
                    if (((Random)random).nextInt(100) >= this.chanceCreeper.getValue()) break;
                    e.getDrops().add(new ItemStack(Material.CREEPER_HEAD));
                    break;
                }
                case WITHER_SKELETON: {
                    if (((Random)random).nextInt(100) >= this.chanceWitherSkeleton.getValue()) break;
                    e.getDrops().add(new ItemStack(Material.WITHER_SKELETON_SKULL));
                    break;
                }
                case PIGLIN: {
                    if (!Slimefun.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_20) || ((Random)random).nextInt(100) >= this.chancePiglin.getValue()) break;
                    e.getDrops().add(new ItemStack(Material.PIGLIN_HEAD));
                    break;
                }
                case PLAYER: {
                    if (((Random)random).nextInt(100) >= this.chancePlayer.getValue()) break;
                    ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
                    ItemMeta meta = skull.getItemMeta();
                    ((SkullMeta)meta).setOwningPlayer((OfflinePlayer)((Player)e.getEntity()));
                    skull.setItemMeta(meta);
                    e.getDrops().add(skull);
                    break;
                }
            }
        };
    }
}

