/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import io.github.thebusybiscuit.slimefun4.core.services.localization.Language;
import io.github.thebusybiscuit.slimefun4.core.services.localization.LanguageFile;
import io.github.thebusybiscuit.slimefun4.core.services.localization.SlimefunLocalization;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import io.github.thebusybiscuit.slimefun4.utils.PatternUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class LocalizationService
extends SlimefunLocalization {
    private static final String LANGUAGE_PATH = "language";
    private final Map<String, Language> languages = new LinkedHashMap<String, Language>();
    private final boolean translationsEnabled;
    private final Slimefun plugin;
    private final String prefix;
    private final NamespacedKey languageKey;
    private final Language defaultLanguage;

    public LocalizationService(@Nonnull Slimefun plugin, @Nullable String prefix, @Nullable String serverDefaultLanguage) {
        super(plugin);
        this.plugin = plugin;
        this.prefix = prefix;
        this.languageKey = new NamespacedKey((Plugin)plugin, LANGUAGE_PATH);
        if (serverDefaultLanguage != null) {
            this.translationsEnabled = Slimefun.getCfg().getBoolean("options.enable-translations");
            this.defaultLanguage = new Language(serverDefaultLanguage, "11b3188fd44902f72602bd7c2141f5a70673a411adb3d81862c69e536166b");
            this.defaultLanguage.setFile(LanguageFile.MESSAGES, this.getConfig().getConfiguration());
            this.loadEmbeddedLanguages();
            String language = this.getConfig().getString(LANGUAGE_PATH);
            if (language == null) {
                language = serverDefaultLanguage;
            }
            if (this.hasLanguage(serverDefaultLanguage)) {
                this.setLanguage(serverDefaultLanguage, !serverDefaultLanguage.equals(language));
            } else {
                this.setLanguage("en", false);
                plugin.getLogger().log(Level.WARNING, "Could not recognize the given language: \"{0}\"", serverDefaultLanguage);
            }
            Slimefun.logger().log(Level.INFO, "Available languages: {0}", String.join((CharSequence)", ", this.languages.keySet()));
            this.save();
        } else {
            this.translationsEnabled = false;
            this.defaultLanguage = null;
        }
    }

    public boolean isEnabled() {
        return this.translationsEnabled;
    }

    @Override
    public String getChatPrefix() {
        return this.prefix;
    }

    @Nonnull
    public NamespacedKey getKey() {
        return this.languageKey;
    }

    @Override
    @Nullable
    public Language getLanguage(@Nonnull String id) {
        Validate.notNull(id, "The language id cannot be null");
        return this.languages.get(id);
    }

    @Override
    @Nonnull
    public Collection<Language> getLanguages() {
        return this.languages.values();
    }

    @Override
    public boolean hasLanguage(@Nonnull String id) {
        Validate.notNull(id, "The language id cannot be null");
        String file = LanguageFile.MESSAGES.getFilePath(id);
        return !this.getConfigurationFromStream(file, null).getKeys(false).isEmpty();
    }

    public boolean isLanguageLoaded(@Nonnull String id) {
        Validate.notNull(id, "The language cannot be null!");
        return this.languages.containsKey(id);
    }

    @Override
    public Language getDefaultLanguage() {
        return this.defaultLanguage;
    }

    @Override
    public Language getLanguage(@Nonnull Player p) {
        Language lang;
        Validate.notNull(p, "Player cannot be null!");
        PersistentDataContainer container = p.getPersistentDataContainer();
        String language = (String)container.get(this.languageKey, PersistentDataType.STRING);
        if (language != null && (lang = this.languages.get(language)) != null) {
            return lang;
        }
        return this.getDefaultLanguage();
    }

    private void setLanguage(@Nonnull String language, boolean reset) {
        if (reset) {
            this.getConfig().clear();
        }
        for (LanguageFile file : LanguageFile.values()) {
            if (file == LanguageFile.MESSAGES) continue;
            this.copyToDefaultLanguage(language, file);
        }
        Slimefun.logger().log(Level.INFO, "Loaded language \"{0}\"", language);
        this.getConfig().setValue(LANGUAGE_PATH, language);
        String path = "/languages/" + language + "/messages.yml";
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.plugin.getClass().getResourceAsStream(path), StandardCharsets.UTF_8));){
            YamlConfiguration config = YamlConfiguration.loadConfiguration((Reader)reader);
            this.getConfig().getConfiguration().setDefaults((Configuration)config);
        }
        catch (IOException e) {
            Slimefun.logger().log(Level.SEVERE, e, () -> "Failed to load language file: \"" + path + "\"");
        }
        this.save();
    }

    @ParametersAreNonnullByDefault
    private void copyToDefaultLanguage(String language, LanguageFile file) {
        FileConfiguration config = this.getConfigurationFromStream(file.getFilePath(language), null);
        this.defaultLanguage.setFile(file, config);
    }

    @Override
    protected void addLanguage(@Nonnull String id, @Nonnull String texture) {
        Validate.notNull(id, "The language id cannot be null!");
        Validate.notNull(texture, "The language texture cannot be null");
        if (this.hasLanguage(id)) {
            Language language = new Language(id, texture);
            for (LanguageFile file : LanguageFile.values()) {
                FileConfiguration defaults = file == LanguageFile.MESSAGES ? this.getConfig().getConfiguration() : null;
                FileConfiguration config = this.getConfigurationFromStream(file.getFilePath(language), defaults);
                language.setFile(file, config);
            }
            this.languages.put(id, language);
        }
    }

    public double calculateProgress(@Nonnull Language lang) {
        Validate.notNull(lang, "Cannot get the language progress of null");
        Set<String> defaultKeys = this.getTotalKeys(this.languages.get("en"));
        if (defaultKeys.isEmpty()) {
            return 0.0;
        }
        Set<String> keys = this.getTotalKeys(lang);
        int matches = 0;
        for (String key : defaultKeys) {
            if (!keys.contains(key)) continue;
            ++matches;
        }
        return Math.min(NumberUtils.reparseDouble(100.0 * ((double)matches / (double)defaultKeys.size())), 100.0);
    }

    @Nonnull
    private FileConfiguration getConfigurationFromStream(@Nonnull String file, @Nullable FileConfiguration defaults) {
        YamlConfiguration yamlConfiguration;
        InputStream inputStream = this.plugin.getClass().getResourceAsStream(file);
        if (inputStream == null) {
            return new YamlConfiguration();
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        try {
            String content = reader.lines().collect(Collectors.joining("\n"));
            YamlConfiguration config = new YamlConfiguration();
            if (PatternUtils.YAML_ENTRY.matcher(content).find()) {
                config.loadFromString(content);
                if (defaults != null) {
                    config.setDefaults((Configuration)defaults);
                }
            }
            yamlConfiguration = config;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | InvalidConfigurationException e) {
                Slimefun.logger().log(Level.WARNING, e, () -> "Failed to load language file into memory: \"" + file + "\"");
                return new YamlConfiguration();
            }
        }
        reader.close();
        return yamlConfiguration;
    }
}

