/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.dough.items.nms;

import io.github.thebusybiscuit.slimefun4.libraries.dough.common.DoughLogger;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.nms.ItemNameAdapter17;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.nms.ItemNameAdapter18;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.nms.ItemNameAdapter18v2;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.nms.ItemNameAdapter19;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.nms.ItemNameAdapter20;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.nms.ItemNameAdapter20v5;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.nms.ItemNameAdapterBefore17;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.nms.ItemNameAdapterMockBukkit;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.nms.ItemNameAdapterPaper;
import io.github.thebusybiscuit.slimefun4.libraries.dough.versions.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.inventory.ItemStack;

public interface ItemNameAdapter {
    @ParametersAreNonnullByDefault
    @Nonnull
    public String getName(ItemStack var1) throws IllegalAccessException, InvocationTargetException;

    @Nullable
    public static ItemNameAdapter get() {
        try {
            if (MinecraftVersion.isMocked()) {
                return new ItemNameAdapterMockBukkit();
            }
            MinecraftVersion version = MinecraftVersion.get();
            if (version.isAtLeast(1, 20, 4) && PaperLib.isPaper()) {
                return new ItemNameAdapterPaper();
            }
            if (version.isAtLeast(1, 20, 5)) {
                return new ItemNameAdapter20v5();
            }
            if (version.isAtLeast(1, 20)) {
                return new ItemNameAdapter20();
            }
            if (version.isAtLeast(1, 19)) {
                return new ItemNameAdapter19();
            }
            if (version.isAtLeast(1, 18, 2)) {
                return new ItemNameAdapter18v2();
            }
            if (version.isAtLeast(1, 18)) {
                return new ItemNameAdapter18();
            }
            if (version.isAtLeast(1, 17)) {
                return new ItemNameAdapter17();
            }
            return new ItemNameAdapterBefore17();
        }
        catch (Exception x) {
            DoughLogger logger = new DoughLogger("items");
            logger.log(Level.SEVERE, "Failed to detect items nbt methods", x);
            return null;
        }
    }
}

