/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.items.magical.talismans.MagicianTalisman;
import io.github.thebusybiscuit.slimefun4.implementation.items.magical.talismans.Talisman;
import io.github.thebusybiscuit.slimefun4.implementation.settings.TalismanEnchantment;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.compatibility.VersionedEnchantment;
import io.github.thebusybiscuit.slimefun4.utils.tags.SlimefunTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Ravager;
import org.bukkit.entity.Trident;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class TalismanListener
implements Listener {
    private final int[] armorSlots = new int[]{39, 38, 37, 36};

    public TalismanListener(@Nonnull Slimefun plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDamageGet(EntityDamageEvent e) {
        if (e.getEntity() instanceof Player) {
            switch (e.getCause()) {
                case LAVA: {
                    Talisman.trigger((Event)e, SlimefunItems.TALISMAN_LAVA);
                    break;
                }
                case DROWNING: {
                    Talisman.trigger((Event)e, SlimefunItems.TALISMAN_WATER);
                    break;
                }
                case FALL: {
                    Talisman.trigger((Event)e, SlimefunItems.TALISMAN_ANGEL);
                    break;
                }
                case FIRE: {
                    Talisman.trigger((Event)e, SlimefunItems.TALISMAN_FIRE);
                    break;
                }
                case ENTITY_ATTACK: {
                    Talisman.trigger((Event)e, SlimefunItems.TALISMAN_KNIGHT);
                    Talisman.trigger((Event)e, SlimefunItems.TALISMAN_WARRIOR);
                    break;
                }
                case PROJECTILE: {
                    if (!(e instanceof EntityDamageByEntityEvent)) break;
                    EntityDamageByEntityEvent entityDamageByEntityEvent = (EntityDamageByEntityEvent)e;
                    this.onProjectileDamage(entityDamageByEntityEvent);
                    break;
                }
            }
        }
    }

    private void onProjectileDamage(@Nonnull EntityDamageByEntityEvent e) {
        Entity entity = e.getDamager();
        if (entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            if (!(e.getDamager() instanceof Trident) && Talisman.trigger((Event)e, SlimefunItems.TALISMAN_WHIRLWIND)) {
                Player p = (Player)e.getEntity();
                this.returnProjectile(p, projectile);
            }
        }
    }

    private void returnProjectile(@Nonnull Player p, @Nonnull Projectile projectile) {
        Vector direction = p.getEyeLocation().getDirection().multiply(2.0);
        Location loc = p.getEyeLocation().add(direction.getX(), direction.getY(), direction.getZ());
        Projectile returnedProjectile = (Projectile)p.getWorld().spawnEntity(loc, projectile.getType());
        returnedProjectile.setShooter(projectile.getShooter());
        returnedProjectile.setVelocity(direction);
        if (projectile instanceof AbstractArrow) {
            AbstractArrow firedArrow = (AbstractArrow)projectile;
            AbstractArrow returnedArrow = (AbstractArrow)returnedProjectile;
            returnedArrow.setDamage(firedArrow.getDamage());
            returnedArrow.setPickupStatus(firedArrow.getPickupStatus());
            returnedArrow.setPierceLevel(firedArrow.getPierceLevel());
        }
        projectile.remove();
    }

    @EventHandler(ignoreCancelled=true)
    public void onKill(EntityDeathEvent e) {
        if (e.getDrops().isEmpty() || e.getEntity().getKiller() == null) {
            return;
        }
        LivingEntity entity = e.getEntity();
        if (entity instanceof Player || entity instanceof ArmorStand) {
            return;
        }
        if (!entity.getCanPickupItems() && Talisman.trigger((Event)e, SlimefunItems.TALISMAN_HUNTER)) {
            Collection<ItemStack> extraDrops = this.getExtraDrops(e.getEntity(), e.getDrops());
            for (ItemStack drop : extraDrops) {
                if (drop == null || drop.getType() == Material.AIR) continue;
                e.getDrops().add(drop.clone());
            }
        }
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    private Collection<ItemStack> getExtraDrops(LivingEntity entity, Collection<ItemStack> drops) {
        EntityEquipment equipment;
        ChestedHorse chestedHorse;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(drops);
        if (entity instanceof ChestedHorse && (chestedHorse = (ChestedHorse)entity).isCarryingChest()) {
            items.remove(new ItemStack(Material.CHEST));
            for (ItemStack item2 : chestedHorse.getInventory().getStorageContents()) {
                items.remove(item2);
            }
        }
        if (!(entity instanceof Ravager)) {
            items.removeIf(item -> item.getType() == Material.SADDLE);
        }
        if ((equipment = entity.getEquipment()) != null) {
            for (ItemStack item2 : equipment.getArmorContents()) {
                items.remove(item2);
            }
            items.remove(equipment.getItemInMainHand());
            items.remove(equipment.getItemInOffHand());
        }
        return items;
    }

    @EventHandler
    public void onItemBreak(PlayerItemBreakEvent e) {
        if (Talisman.trigger((Event)e, SlimefunItems.TALISMAN_ANVIL)) {
            PlayerInventory inv = e.getPlayer().getInventory();
            ItemStack brokenItem = e.getBrokenItem();
            int slot = -1;
            if (brokenItem.equals((Object)inv.getItemInMainHand())) {
                slot = inv.getHeldItemSlot();
            } else if (brokenItem.equals((Object)inv.getItemInOffHand())) {
                slot = 40;
            } else {
                for (int s : this.armorSlots) {
                    if (!e.getBrokenItem().equals((Object)inv.getItem(s))) continue;
                    slot = s;
                    break;
                }
            }
            if (slot < 0) {
                return;
            }
            ItemStack item = e.getBrokenItem().clone();
            ItemMeta meta = item.getItemMeta();
            if (meta instanceof Damageable) {
                Damageable damageable = (Damageable)meta;
                damageable.setDamage(0);
            }
            item.setItemMeta(meta);
            int itemSlot = slot;
            Slimefun.runSync(() -> inv.setItem(itemSlot, item), 1L);
        }
    }

    @EventHandler
    public void onSprint(PlayerToggleSprintEvent e) {
        if (e.isSprinting()) {
            Talisman.trigger((Event)e, SlimefunItems.TALISMAN_TRAVELLER);
        }
    }

    @EventHandler
    public void onEnchant(EnchantItemEvent e) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        Map enchantments = e.getEnchantsToAdd();
        MagicianTalisman talisman = (MagicianTalisman)SlimefunItems.TALISMAN_MAGICIAN.getItem();
        TalismanEnchantment enchantment = talisman.getRandomEnchantment(e.getItem(), enchantments.keySet());
        if (enchantment != null && Talisman.trigger((Event)e, SlimefunItems.TALISMAN_MAGICIAN)) {
            if (talisman.isEnchantmentBookAllowed() && e.getItem().getType() == Material.BOOK) {
                e.getItem().addUnsafeEnchantment(enchantment.getEnchantment(), enchantment.getLevel());
            } else {
                enchantments.put(enchantment.getEnchantment(), enchantment.getLevel());
            }
        }
        if (!enchantments.containsKey(Enchantment.SILK_TOUCH) && VersionedEnchantment.FORTUNE.canEnchantItem(e.getItem()) && Talisman.trigger((Event)e, SlimefunItems.TALISMAN_WIZARD)) {
            for (Map.Entry entry : enchantments.entrySet()) {
                if ((Integer)entry.getValue() <= 1 || ((Random)random).nextInt(100) >= 40) continue;
                enchantments.put((Enchantment)entry.getKey(), (Integer)entry.getValue() - 1);
            }
            enchantments.put(VersionedEnchantment.FORTUNE, ((Random)random).nextInt(3) + 3);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onExperienceReceive(PlayerExpChangeEvent e) {
        if (e.getAmount() > 0 && Talisman.trigger((Event)e, SlimefunItems.TALISMAN_WISE)) {
            e.setAmount(e.getAmount() * 2);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockDropItems(BlockDropItemEvent e) {
        ItemStack item = e.getPlayer().getInventory().getItemInMainHand();
        if (item.getType() != Material.AIR && item.getAmount() > 0) {
            ItemMeta meta = item.getItemMeta();
            if (meta.hasEnchant(Enchantment.SILK_TOUCH)) {
                return;
            }
            Material type = e.getBlockState().getType();
            this.doubleTalismanDrops(e, SlimefunItems.TALISMAN_MINER, SlimefunTag.MINER_TALISMAN_TRIGGERS, type, meta);
            this.doubleTalismanDrops(e, SlimefunItems.TALISMAN_FARMER, SlimefunTag.FARMER_TALISMAN_TRIGGERS, type, meta);
        }
    }

    private void doubleTalismanDrops(BlockDropItemEvent e, SlimefunItemStack talismanItemStack, SlimefunTag tag, Material type, ItemMeta meta) {
        if (tag.isTagged(type)) {
            List drops = e.getItems();
            if (Talisman.trigger((Event)e, talismanItemStack, false)) {
                Talisman talisman;
                int dropAmount = this.getAmountWithFortune(type, meta.getEnchantLevel(VersionedEnchantment.FORTUNE));
                boolean doubledDrops = false;
                for (Item drop : drops) {
                    ItemStack droppedItem = drop.getItemStack();
                    if (droppedItem.getType().isBlock()) continue;
                    int amount = Math.max(1, dropAmount * 2 - droppedItem.getAmount());
                    e.getBlock().getWorld().dropItemNaturally(e.getBlock().getLocation(), (ItemStack)new CustomItemStack(droppedItem, amount));
                    doubledDrops = true;
                }
                if (doubledDrops && (talisman = talismanItemStack.getItem(Talisman.class)) != null) {
                    talisman.sendMessage(e.getPlayer());
                }
            }
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent e) {
        if (SlimefunTag.CAVEMAN_TALISMAN_TRIGGERS.isTagged(e.getBlock().getType())) {
            Talisman.trigger((Event)e, SlimefunItems.TALISMAN_CAVEMAN);
        }
    }

    private int getAmountWithFortune(@Nonnull Material type, int fortuneLevel) {
        if (fortuneLevel > 0) {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            int amount = ((Random)random).nextInt(fortuneLevel + 2) - 1;
            amount = Math.max(amount, 1);
            amount = (type == Material.LAPIS_ORE ? 4 + ((Random)random).nextInt(5) : 1) * (amount + 1);
            return amount;
        }
        return 1;
    }
}

