/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.ItemStackWrapper;
import java.util.function.Predicate;
import org.bukkit.inventory.ItemStack;

public class MachineFuel
implements Predicate<ItemStack> {
    private final int ticks;
    private final ItemStack fuel;
    private final ItemStack output;
    private final ItemStackWrapper wrapper;

    public MachineFuel(int seconds, ItemStack fuel) {
        this(seconds, fuel, null);
    }

    public MachineFuel(int seconds, ItemStack fuel, ItemStack output) {
        Validate.notNull(fuel, "Fuel must never be null!");
        Validate.isTrue(seconds > 0, "Fuel must last at least one second!");
        this.ticks = seconds * 2;
        this.fuel = fuel;
        this.wrapper = ItemStackWrapper.wrap(fuel);
        this.output = output;
    }

    public MachineFuel(int seconds, SlimefunItemStack fuel) {
        this(seconds, fuel.item(), null);
    }

    public MachineFuel(int seconds, SlimefunItemStack fuel, SlimefunItemStack output) {
        Validate.notNull(fuel, "Fuel must never be null!");
        Validate.isTrue(seconds > 0, "Fuel must last at least one second!");
        this.ticks = seconds * 2;
        this.fuel = fuel.item();
        this.wrapper = ItemStackWrapper.wrap(this.fuel);
        this.output = output != null ? output.item() : null;
    }

    public ItemStack getInput() {
        return this.fuel;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public int getTicks() {
        return this.ticks;
    }

    @Override
    public boolean test(ItemStack item) {
        return SlimefunUtils.isItemSimilar(item, this.wrapper, true);
    }
}

