/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.dough.protection.modules;

import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.ActionType;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.ProtectionModule;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;
import org.popcraft.bolt.BoltAPI;
import org.popcraft.bolt.protection.Protection;

public class BoltProtectionModule
implements ProtectionModule {
    private BoltAPI bolt;
    private final Plugin plugin;

    public BoltProtectionModule(@Nonnull Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public void load() {
        this.bolt = (BoltAPI)this.plugin.getServer().getServicesManager().load(BoltAPI.class);
    }

    @Override
    public boolean hasPermission(OfflinePlayer p, Location l, Interaction action) {
        if (action.getType() != ActionType.BLOCK) {
            return true;
        }
        String permission = this.boltPermission(action);
        if (permission == null) {
            return true;
        }
        Protection protection = this.bolt.findProtection(l.getBlock());
        return this.bolt.canAccess(protection, p.getUniqueId(), new String[]{permission});
    }

    private String boltPermission(Interaction interaction) {
        switch (interaction) {
            case BREAK_BLOCK: 
            case ATTACK_PLAYER: 
            case ATTACK_ENTITY: {
                return "destroy";
            }
            case PLACE_BLOCK: 
            case INTERACT_BLOCK: 
            case INTERACT_ENTITY: {
                return "interact";
            }
        }
        return null;
    }
}

