/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.tasks.armor;

import io.github.thebusybiscuit.slimefun4.api.items.HashedArmorpiece;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.implementation.items.armor.RainbowArmorPiece;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.armor.AbstractArmorTask;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Color;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;

public class RainbowArmorTask
extends AbstractArmorTask {
    private long currentColorIndex = 0L;

    @Override
    protected void onTick() {
        ++this.currentColorIndex;
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void onPlayerTick(Player p, PlayerProfile profile) {
        for (int i = 0; i < 4; ++i) {
            ItemStack item = p.getInventory().getArmorContents()[i];
            if (item == null || !item.hasItemMeta()) continue;
            HashedArmorpiece armorPiece = profile.getArmor()[i];
            armorPiece.getItem().ifPresent(sfArmorPiece -> {
                RainbowArmorPiece rainbowArmorPiece;
                if (sfArmorPiece instanceof RainbowArmorPiece && (rainbowArmorPiece = (RainbowArmorPiece)sfArmorPiece).canUse(p, true)) {
                    this.updateRainbowArmor(item, rainbowArmorPiece);
                }
            });
        }
    }

    @ParametersAreNonnullByDefault
    private void updateRainbowArmor(ItemStack itemStack, RainbowArmorPiece armorPiece) {
        Color[] colors = armorPiece.getColors();
        Color newColor = colors[(int)(this.currentColorIndex % (long)colors.length)];
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta instanceof LeatherArmorMeta) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemMeta;
            leatherArmorMeta.setColor(newColor);
            itemStack.setItemMeta((ItemMeta)leatherArmorMeta);
        }
    }
}

