/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines.accelerators;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines.accelerators.AbstractGrowthAccelerator;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.github.thebusybiscuit.slimefun4.utils.compatibility.VersionedParticle;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.ItemStackWrapper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Keyed;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Sapling;
import org.bukkit.inventory.ItemStack;

public class TreeGrowthAccelerator
extends AbstractGrowthAccelerator {
    private static final int ENERGY_CONSUMPTION = 24;
    private static final int RADIUS = 9;
    private static final ItemStack organicFertilizer = ItemStackWrapper.wrap(SlimefunItems.FERTILIZER.item());

    @ParametersAreNonnullByDefault
    public TreeGrowthAccelerator(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    @Override
    public int getCapacity() {
        return 1024;
    }

    @Override
    protected void tick(@Nonnull Block b) {
        BlockMenu inv = BlockStorage.getInventory(b);
        if (this.getCharge(b.getLocation()) >= 24) {
            for (int x = -9; x <= 9; ++x) {
                for (int z = -9; z <= 9; ++z) {
                    boolean isGrowthBoosted;
                    Block block = b.getRelative(x, 0, z);
                    if (!Tag.SAPLINGS.isTagged((Keyed)block.getType()) || !(isGrowthBoosted = this.tryToBoostGrowth(b, inv, block))) continue;
                    return;
                }
            }
        }
    }

    @ParametersAreNonnullByDefault
    private boolean tryToBoostGrowth(Block machine, BlockMenu inv, Block sapling) {
        if (Slimefun.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_17)) {
            return this.applyBoneMeal(machine, sapling, inv);
        }
        Sapling saplingData = (Sapling)sapling.getBlockData();
        return saplingData.getStage() < saplingData.getMaximumStage() && this.updateSaplingData(machine, sapling, inv, saplingData);
    }

    @ParametersAreNonnullByDefault
    private boolean applyBoneMeal(Block machine, Block sapling, BlockMenu inv) {
        for (int slot : this.getInputSlots()) {
            if (!this.isFertilizer(inv.getItemInSlot(slot))) continue;
            this.removeCharge(machine.getLocation(), 24);
            sapling.applyBoneMeal(BlockFace.UP);
            inv.consumeItem(slot);
            sapling.getWorld().spawnParticle(VersionedParticle.HAPPY_VILLAGER, sapling.getLocation().add(0.5, 0.5, 0.5), 4, (double)0.1f, (double)0.1f, (double)0.1f);
            return true;
        }
        return false;
    }

    @ParametersAreNonnullByDefault
    private boolean updateSaplingData(Block machine, Block block, BlockMenu inv, Sapling sapling) {
        for (int slot : this.getInputSlots()) {
            if (!this.isFertilizer(inv.getItemInSlot(slot))) continue;
            this.removeCharge(machine.getLocation(), 24);
            sapling.setStage(sapling.getStage() + 1);
            block.setBlockData((BlockData)sapling, false);
            inv.consumeItem(slot);
            block.getWorld().spawnParticle(VersionedParticle.HAPPY_VILLAGER, block.getLocation().add(0.5, 0.5, 0.5), 4, (double)0.1f, (double)0.1f, (double)0.1f);
            return true;
        }
        return false;
    }

    protected boolean isFertilizer(@Nullable ItemStack item) {
        return SlimefunUtils.isItemSimilar(item, organicFertilizer, false, false);
    }
}

