/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.cargo;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.handlers.SimpleBlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.implementation.items.electric.reactors.Reactor;
import io.github.thebusybiscuit.slimefun4.implementation.items.misc.CoolantCell;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ReactorAccessPort
extends SlimefunItem {
    private static final int INFO_SLOT = 49;
    private final int[] background = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 12, 13, 14, 21, 23};
    private final int[] fuelBorder = new int[]{9, 10, 11, 18, 20, 27, 29, 36, 38, 45, 46, 47};
    private final int[] inputBorder = new int[]{15, 16, 17, 24, 26, 33, 35, 42, 44, 51, 52, 53};
    private final int[] outputBorder = new int[]{30, 31, 32, 39, 41, 48, 50};

    @ParametersAreNonnullByDefault
    public ReactorAccessPort(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        this.addItemHandler(this.onBreak());
        new BlockMenuPreset(this.getId(), "&2Reactor Access Port"){

            @Override
            public void init() {
                ReactorAccessPort.this.constructMenu(this);
            }

            @Override
            public boolean canOpen(Block b, Player p) {
                return p.hasPermission("slimefun.inventory.bypass") || Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), Interaction.INTERACT_BLOCK);
            }

            @Override
            public void newInstance(BlockMenu menu, Block b) {
                BlockMenu reactor = ReactorAccessPort.this.getReactor(b.getLocation());
                if (reactor != null) {
                    menu.replaceExistingItem(49, CustomItemStack.create(Material.GREEN_WOOL, "&7Reactor", "", "&6Detected", "", "&7> Click to view Reactor"));
                    menu.addMenuClickHandler(49, (p, slot, item, action) -> {
                        if (reactor != null) {
                            reactor.open(p);
                        }
                        this.newInstance(menu, b);
                        return false;
                    });
                } else {
                    menu.replaceExistingItem(49, CustomItemStack.create(Material.RED_WOOL, "&7Reactor", "", "&cNot detected", "", "&7Reactor must be", "&7placed 3 blocks below", "&7the access port!"));
                    menu.addMenuClickHandler(49, (p, slot, item, action) -> {
                        this.newInstance(menu, b);
                        return false;
                    });
                }
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                if (flow == ItemTransportFlow.INSERT) {
                    return ReactorAccessPort.this.getInputSlots();
                }
                return ReactorAccessPort.getOutputSlots();
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(DirtyChestMenu menu, ItemTransportFlow flow, ItemStack item) {
                if (flow == ItemTransportFlow.INSERT) {
                    if (SlimefunItem.getByItem(item) instanceof CoolantCell) {
                        return ReactorAccessPort.this.getCoolantSlots();
                    }
                    return ReactorAccessPort.this.getFuelSlots();
                }
                return ReactorAccessPort.getOutputSlots();
            }
        };
    }

    @Nonnull
    private BlockBreakHandler onBreak() {
        return new SimpleBlockBreakHandler(){

            @Override
            public void onBlockBreak(@Nonnull Block b) {
                BlockMenu inv = BlockStorage.getInventory(b);
                if (inv != null) {
                    inv.dropItems(b.getLocation(), ReactorAccessPort.this.getFuelSlots());
                    inv.dropItems(b.getLocation(), ReactorAccessPort.this.getCoolantSlots());
                    inv.dropItems(b.getLocation(), ReactorAccessPort.getOutputSlots());
                }
            }
        };
    }

    private void constructMenu(@Nonnull BlockMenuPreset preset) {
        preset.drawBackground(ChestMenuUtils.getBackground(), this.background);
        preset.drawBackground(CustomItemStack.create(Material.LIME_STAINED_GLASS_PANE, " ", new String[0]), this.fuelBorder);
        preset.drawBackground(CustomItemStack.create(Material.CYAN_STAINED_GLASS_PANE, " ", new String[0]), this.inputBorder);
        preset.drawBackground(CustomItemStack.create(Material.GREEN_STAINED_GLASS_PANE, " ", new String[0]), this.outputBorder);
        preset.addItem(1, CustomItemStack.create(SlimefunItems.URANIUM, "&7Fuel Slot", "", "&rThis Slot accepts radioactive Fuel such as:", "&2Uranium &ror &aNeptunium"), ChestMenuUtils.getEmptyClickHandler());
        preset.addItem(22, CustomItemStack.create(SlimefunItems.PLUTONIUM, "&7Byproduct Slot", "", "&rThis Slot contains the Reactor's Byproduct", "&rsuch as &aNeptunium &ror &7Plutonium"), ChestMenuUtils.getEmptyClickHandler());
        preset.addItem(7, CustomItemStack.create(SlimefunItems.REACTOR_COOLANT_CELL, "&bCoolant Slot", "", "&rThis Slot accepts Coolant Cells", "&4Without any Coolant Cells, your Reactor", "&4will explode"), ChestMenuUtils.getEmptyClickHandler());
    }

    @Nonnull
    public int[] getInputSlots() {
        return new int[]{19, 28, 37, 25, 34, 43};
    }

    @Nonnull
    public int[] getFuelSlots() {
        return new int[]{19, 28, 37};
    }

    @Nonnull
    public int[] getCoolantSlots() {
        return new int[]{25, 34, 43};
    }

    @Nonnull
    public static int[] getOutputSlots() {
        return new int[]{40};
    }

    @Nullable
    private BlockMenu getReactor(@Nonnull Location l) {
        Location location = new Location(l.getWorld(), l.getX(), l.getY() - 3.0, l.getZ());
        SlimefunItem item = BlockStorage.check(location.getBlock());
        if (item instanceof Reactor) {
            return BlockStorage.getInventory(location);
        }
        return null;
    }
}

