/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.plugin.Plugin;

public class MiddleClickListener
implements Listener {
    public MiddleClickListener(@Nonnull Slimefun plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onInventoryCreativeEvent(InventoryCreativeEvent e) {
        if (e.getClick() == ClickType.CREATIVE && e.getSlotType() == InventoryType.SlotType.QUICKBAR) {
            HumanEntity player = e.getWhoClicked();
            Block b = player.getTargetBlockExact(5);
            if (b == null || !this.isActualMiddleClick(e, b)) {
                return;
            }
            SlimefunItem sfItem = BlockStorage.check(b);
            if (sfItem == null) {
                return;
            }
            for (int i = 0; i < 9; ++i) {
                if (!sfItem.isItem(player.getInventory().getItem(i))) continue;
                player.getInventory().setHeldItemSlot(i);
                e.setCancelled(true);
                return;
            }
            e.setCursor(sfItem.getItem().clone());
        }
    }

    @ParametersAreNonnullByDefault
    private boolean isActualMiddleClick(InventoryCreativeEvent e, Block b) {
        boolean isOutsideInventoryClick = e.getCursor().getType() == b.getType() && e.getCurrentItem().getType() == Material.AIR;
        boolean isPlayerWallhead = b.getType() == Material.PLAYER_WALL_HEAD && e.getCursor().getType() == Material.PLAYER_HEAD;
        return isOutsideInventoryClick || isPlayerWallhead;
    }
}

