/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.guide;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.groups.FlexItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.groups.LockedItemGroup;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.api.researches.Research;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.core.guide.GuideHistory;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuide;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.core.guide.options.SlimefunGuideSettings;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlock;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlockMachine;
import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundEffect;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.AsyncRecipeChoiceTask;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.chat.ChatInput;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import io.github.thebusybiscuit.slimefun4.libraries.dough.recipes.MinecraftRecipe;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.compatibility.VersionedItemFlag;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.SlimefunGuideItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class SurvivalSlimefunGuide
implements SlimefunGuideImplementation {
    private static final int MAX_ITEM_GROUPS = 36;
    private final int[] recipeSlots = new int[]{3, 4, 5, 12, 13, 14, 21, 22, 23};
    private final ItemStack item;
    private final boolean showVanillaRecipes;
    private final boolean showHiddenItemGroupsInSearch;

    public SurvivalSlimefunGuide(boolean showVanillaRecipes, boolean showHiddenItemGroupsInSearch) {
        this.showVanillaRecipes = showVanillaRecipes;
        this.showHiddenItemGroupsInSearch = showHiddenItemGroupsInSearch;
        this.item = new SlimefunGuideItem(this, "&aSlimefun Guide &7(Chest GUI)");
    }

    @Override
    @Nonnull
    public SlimefunGuideMode getMode() {
        return SlimefunGuideMode.SURVIVAL_MODE;
    }

    @Override
    @Nonnull
    public ItemStack getItem() {
        return this.item;
    }

    protected final boolean isSurvivalMode() {
        return this.getMode() != SlimefunGuideMode.CHEAT_MODE;
    }

    @Nonnull
    protected List<ItemGroup> getVisibleItemGroups(@Nonnull Player p, @Nonnull PlayerProfile profile) {
        LinkedList<ItemGroup> groups = new LinkedList<ItemGroup>();
        for (ItemGroup group : Slimefun.getRegistry().getAllItemGroups()) {
            try {
                if (group instanceof FlexItemGroup) {
                    FlexItemGroup flexItemGroup = (FlexItemGroup)group;
                    if (!flexItemGroup.isVisible(p, profile, this.getMode())) continue;
                    groups.add(group);
                    continue;
                }
                if (group.isHidden(p)) continue;
                groups.add(group);
            }
            catch (Exception | LinkageError x) {
                SlimefunAddon addon = group.getAddon();
                if (addon != null) {
                    addon.getLogger().log(Level.SEVERE, x, () -> "Could not display item group: " + String.valueOf(group));
                    continue;
                }
                Slimefun.logger().log(Level.SEVERE, x, () -> "Could not display item group: " + String.valueOf(group));
            }
        }
        return groups;
    }

    @Override
    public void openMainMenu(PlayerProfile profile, int page) {
        Player p = profile.getPlayer();
        if (p == null) {
            return;
        }
        if (this.isSurvivalMode()) {
            GuideHistory history = profile.getGuideHistory();
            history.clear();
            history.setMainMenuPage(page);
        }
        ChestMenu menu = this.create(p);
        List<ItemGroup> itemGroups = this.getVisibleItemGroups(p, profile);
        this.createHeader(p, profile, menu);
        int target = 36 * (page - 1) - 1;
        for (int index = 9; target < itemGroups.size() - 1 && index < 45; ++index) {
            ItemGroup group = itemGroups.get(++target);
            this.showItemGroup(menu, p, profile, group, index);
        }
        int pages = target == itemGroups.size() - 1 ? page : (itemGroups.size() - 1) / 36 + 1;
        menu.addItem(46, ChestMenuUtils.getPreviousButton(p, page, pages));
        menu.addMenuClickHandler(46, (pl, slot, item, action) -> {
            int next = page - 1;
            if (next != page && next > 0) {
                this.openMainMenu(profile, next);
            }
            return false;
        });
        menu.addItem(52, ChestMenuUtils.getNextButton(p, page, pages));
        menu.addMenuClickHandler(52, (pl, slot, item, action) -> {
            int next = page + 1;
            if (next != page && next <= pages) {
                this.openMainMenu(profile, next);
            }
            return false;
        });
        menu.open(p);
    }

    private void showItemGroup(ChestMenu menu, Player p, PlayerProfile profile, ItemGroup group, int index) {
        if (!(group instanceof LockedItemGroup) || !this.isSurvivalMode() || ((LockedItemGroup)group).hasUnlocked(p, profile)) {
            menu.addItem(index, group.getItem(p));
            menu.addMenuClickHandler(index, (pl, slot, item, action) -> {
                this.openItemGroup(profile, group, 1);
                return false;
            });
        } else {
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add("");
            for (String line : Slimefun.getLocalization().getMessages(p, "guide.locked-itemgroup")) {
                lore.add(String.valueOf(ChatColor.WHITE) + line);
            }
            lore.add("");
            for (ItemGroup parent : ((LockedItemGroup)group).getParents()) {
                lore.add(parent.getItem(p).getItemMeta().getDisplayName());
            }
            menu.addItem(index, new CustomItemStack(Material.BARRIER, "&4" + Slimefun.getLocalization().getMessage(p, "guide.locked") + " &7- &f" + group.getItem(p).getItemMeta().getDisplayName(), lore.toArray(new String[0])));
            menu.addMenuClickHandler(index, ChestMenuUtils.getEmptyClickHandler());
        }
    }

    @Override
    @ParametersAreNonnullByDefault
    public void openItemGroup(PlayerProfile profile, ItemGroup itemGroup, int page) {
        int target;
        Player p = profile.getPlayer();
        if (p == null) {
            return;
        }
        if (itemGroup instanceof FlexItemGroup) {
            FlexItemGroup flexItemGroup = (FlexItemGroup)itemGroup;
            flexItemGroup.open(p, profile, this.getMode());
            return;
        }
        if (this.isSurvivalMode()) {
            profile.getGuideHistory().add(itemGroup, page);
        }
        ChestMenu menu = this.create(p);
        this.createHeader(p, profile, menu);
        this.addBackButton(menu, 1, p, profile);
        int pages = (itemGroup.getItems().size() - 1) / 36 + 1;
        menu.addItem(46, ChestMenuUtils.getPreviousButton(p, page, pages));
        menu.addMenuClickHandler(46, (pl, slot, item, action) -> {
            int next = page - 1;
            if (next != page && next > 0) {
                this.openItemGroup(profile, itemGroup, next);
            }
            return false;
        });
        menu.addItem(52, ChestMenuUtils.getNextButton(p, page, pages));
        menu.addMenuClickHandler(52, (pl, slot, item, action) -> {
            int next = page + 1;
            if (next != page && next <= pages) {
                this.openItemGroup(profile, itemGroup, next);
            }
            return false;
        });
        int index = 9;
        int itemGroupIndex = 36 * (page - 1);
        for (int i = 0; i < 36 && (target = itemGroupIndex + i) < itemGroup.getItems().size(); ++i) {
            SlimefunItem sfitem = itemGroup.getItems().get(target);
            if (sfitem.isDisabledIn(p.getWorld())) continue;
            this.displaySlimefunItem(menu, itemGroup, p, profile, sfitem, page, index);
            ++index;
        }
        menu.open(p);
    }

    private void displaySlimefunItem(ChestMenu menu, ItemGroup itemGroup, Player p, PlayerProfile profile, SlimefunItem sfitem, int page, int index) {
        Research research = sfitem.getResearch();
        if (this.isSurvivalMode() && !SurvivalSlimefunGuide.hasPermission(p, sfitem)) {
            List<String> message = Slimefun.getPermissionsService().getLore(sfitem);
            menu.addItem(index, new CustomItemStack(ChestMenuUtils.getNoPermissionItem(), sfitem.getItemName(), message.toArray(new String[0])));
            menu.addMenuClickHandler(index, ChestMenuUtils.getEmptyClickHandler());
        } else if (this.isSurvivalMode() && research != null && !profile.hasUnlocked(research)) {
            menu.addItem(index, new CustomItemStack(ChestMenuUtils.getNotResearchedItem(), String.valueOf(ChatColor.WHITE) + ItemUtils.getItemName(sfitem.getItem()), "&4&l" + Slimefun.getLocalization().getMessage(p, "guide.locked"), "", "&a> Click to unlock", "", "&7Cost: &b" + research.getCost() + " Level(s)"));
            menu.addMenuClickHandler(index, (pl, slot, item, action) -> {
                research.unlockFromGuide(this, p, profile, sfitem, itemGroup, page);
                return false;
            });
        } else {
            menu.addItem(index, sfitem.getItem());
            menu.addMenuClickHandler(index, (pl, slot, item, action) -> {
                try {
                    if (this.isSurvivalMode()) {
                        this.displayItem(profile, sfitem, true);
                    } else if (pl.hasPermission("slimefun.cheat.items")) {
                        if (sfitem instanceof MultiBlockMachine) {
                            Slimefun.getLocalization().sendMessage((CommandSender)pl, "guide.cheat.no-multiblocks");
                        } else {
                            ItemStack clonedItem = sfitem.getItem().clone();
                            if (action.isShiftClicked()) {
                                clonedItem.setAmount(clonedItem.getMaxStackSize());
                            }
                            pl.getInventory().addItem(new ItemStack[]{clonedItem});
                        }
                    } else {
                        Slimefun.getLocalization().sendMessage((CommandSender)pl, "messages.no-permission", true);
                    }
                }
                catch (Exception | LinkageError x) {
                    this.printErrorMessage(pl, sfitem, x);
                }
                return false;
            });
        }
    }

    @Override
    @ParametersAreNonnullByDefault
    public void openSearch(PlayerProfile profile, String input, boolean addToHistory) {
        Player p = profile.getPlayer();
        if (p == null) {
            return;
        }
        ChestMenu menu = new ChestMenu(Slimefun.getLocalization().getMessage(p, "guide.search.inventory").replace("%item%", ChatUtils.crop(ChatColor.WHITE, input)));
        String searchTerm = ChatColor.stripColor((String)input.toLowerCase(Locale.ROOT));
        if (addToHistory) {
            profile.getGuideHistory().add(searchTerm);
        }
        menu.setEmptySlotsClickable(false);
        this.createHeader(p, profile, menu);
        this.addBackButton(menu, 1, p, profile);
        int index = 9;
        for (SlimefunItem slimefunItem : Slimefun.getRegistry().getEnabledSlimefunItems()) {
            if (index == 44) break;
            if (slimefunItem.isHidden() || !this.isItemGroupAccessible(p, slimefunItem) || !this.isSearchFilterApplicable(slimefunItem, searchTerm)) continue;
            CustomItemStack itemstack = new CustomItemStack(slimefunItem.getItem(), meta -> {
                ItemGroup itemGroup = slimefunItem.getItemGroup();
                meta.setLore(Arrays.asList("", String.valueOf(ChatColor.DARK_GRAY) + "\u21e8 " + String.valueOf(ChatColor.WHITE) + itemGroup.getDisplayName(p)));
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS, VersionedItemFlag.HIDE_ADDITIONAL_TOOLTIP});
            });
            menu.addItem(index, itemstack);
            menu.addMenuClickHandler(index, (pl, slot, itm, action) -> {
                try {
                    if (this.isSurvivalMode()) {
                        this.displayItem(profile, slimefunItem, true);
                    } else if (pl.hasPermission("slimefun.cheat.items")) {
                        if (slimefunItem instanceof MultiBlockMachine) {
                            Slimefun.getLocalization().sendMessage((CommandSender)pl, "guide.cheat.no-multiblocks");
                        } else {
                            ItemStack clonedItem = slimefunItem.getItem().clone();
                            if (action.isShiftClicked()) {
                                clonedItem.setAmount(clonedItem.getMaxStackSize());
                            }
                            pl.getInventory().addItem(new ItemStack[]{clonedItem});
                        }
                    } else {
                        Slimefun.getLocalization().sendMessage((CommandSender)pl, "messages.no-permission", true);
                    }
                }
                catch (Exception | LinkageError x) {
                    this.printErrorMessage(pl, slimefunItem, x);
                }
                return false;
            });
            ++index;
        }
        menu.open(p);
    }

    @ParametersAreNonnullByDefault
    private boolean isItemGroupAccessible(Player p, SlimefunItem slimefunItem) {
        return this.showHiddenItemGroupsInSearch || slimefunItem.getItemGroup().isAccessible(p);
    }

    @ParametersAreNonnullByDefault
    private boolean isSearchFilterApplicable(SlimefunItem slimefunItem, String searchTerm) {
        String itemName = ChatColor.stripColor((String)slimefunItem.getItemName()).toLowerCase(Locale.ROOT);
        return !itemName.isEmpty() && (itemName.equals(searchTerm) || itemName.contains(searchTerm));
    }

    @Override
    @ParametersAreNonnullByDefault
    public void displayItem(PlayerProfile profile, ItemStack item, int index, boolean addToHistory) {
        Player p = profile.getPlayer();
        if (p == null || item == null || item.getType() == Material.AIR) {
            return;
        }
        SlimefunItem sfItem = SlimefunItem.getByItem(item);
        if (sfItem != null) {
            this.displayItem(profile, sfItem, addToHistory);
            return;
        }
        if (!this.showVanillaRecipes) {
            return;
        }
        Recipe[] recipes = Slimefun.getMinecraftRecipeService().getRecipesFor(item);
        if (recipes.length == 0) {
            return;
        }
        this.showMinecraftRecipe(recipes, index, item, profile, p, addToHistory);
    }

    private void showMinecraftRecipe(Recipe[] recipes, int index, ItemStack item, PlayerProfile profile, Player p, boolean addToHistory) {
        Recipe recipe = recipes[index];
        ItemStack[] recipeItems = new ItemStack[9];
        RecipeType recipeType = RecipeType.NULL;
        ItemStack result = null;
        Optional<MinecraftRecipe<Recipe>> optional = MinecraftRecipe.of(recipe);
        AsyncRecipeChoiceTask task = new AsyncRecipeChoiceTask();
        if (optional.isPresent()) {
            this.showRecipeChoices(recipe, recipeItems, task);
            recipeType = new RecipeType(optional.get());
            result = recipe.getResult();
        } else {
            recipeItems = new ItemStack[]{null, null, null, null, new CustomItemStack(Material.BARRIER, "&4We are somehow unable to show you this Recipe :/", new String[0]), null, null, null, null};
        }
        ChestMenu menu = this.create(p);
        if (addToHistory) {
            profile.getGuideHistory().add(item, index);
        }
        this.displayItem(menu, profile, p, item, result, recipeType, recipeItems, task);
        if (recipes.length > 1) {
            for (int i = 27; i < 36; ++i) {
                menu.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
            }
            menu.addItem(28, ChestMenuUtils.getPreviousButton(p, index + 1, recipes.length), (pl, slot, action, stack) -> {
                if (index > 0) {
                    this.showMinecraftRecipe(recipes, index - 1, item, profile, p, true);
                }
                return false;
            });
            menu.addItem(34, ChestMenuUtils.getNextButton(p, index + 1, recipes.length), (pl, slot, action, stack) -> {
                if (index < recipes.length - 1) {
                    this.showMinecraftRecipe(recipes, index + 1, item, profile, p, true);
                }
                return false;
            });
        }
        menu.open(p);
        if (!task.isEmpty()) {
            task.start(menu.toInventory());
        }
    }

    private <T extends Recipe> void showRecipeChoices(T recipe, ItemStack[] recipeItems, AsyncRecipeChoiceTask task) {
        RecipeChoice recipeChoice;
        RecipeChoice[] choices = Slimefun.getMinecraftRecipeService().getRecipeShape(recipe);
        if (choices.length == 1 && (recipeChoice = choices[0]) instanceof RecipeChoice.MaterialChoice) {
            RecipeChoice.MaterialChoice materialChoice = (RecipeChoice.MaterialChoice)recipeChoice;
            recipeItems[4] = new ItemStack((Material)materialChoice.getChoices().get(0));
            if (materialChoice.getChoices().size() > 1) {
                task.add(this.recipeSlots[4], materialChoice);
            }
        } else {
            for (int i = 0; i < choices.length; ++i) {
                RecipeChoice recipeChoice2 = choices[i];
                if (!(recipeChoice2 instanceof RecipeChoice.MaterialChoice)) continue;
                RecipeChoice.MaterialChoice materialChoice = (RecipeChoice.MaterialChoice)recipeChoice2;
                recipeItems[i] = new ItemStack((Material)materialChoice.getChoices().get(0));
                if (materialChoice.getChoices().size() <= 1) continue;
                task.add(this.recipeSlots[i], materialChoice);
            }
        }
    }

    @Override
    @ParametersAreNonnullByDefault
    public void displayItem(PlayerProfile profile, SlimefunItem item, boolean addToHistory) {
        Player p = profile.getPlayer();
        if (p == null) {
            return;
        }
        ChestMenu menu = this.create(p);
        Optional<String> wiki = item.getWikipage();
        if (wiki.isPresent()) {
            menu.addItem(8, new CustomItemStack(Material.KNOWLEDGE_BOOK, String.valueOf(ChatColor.WHITE) + Slimefun.getLocalization().getMessage(p, "guide.tooltips.wiki"), "", String.valueOf(ChatColor.GRAY) + "\u21e8 " + String.valueOf(ChatColor.GREEN) + Slimefun.getLocalization().getMessage(p, "guide.tooltips.open-itemgroup")));
            menu.addMenuClickHandler(8, (pl, slot, itemstack, action) -> {
                pl.closeInventory();
                ChatUtils.sendURL((CommandSender)pl, (String)wiki.get());
                return false;
            });
        }
        AsyncRecipeChoiceTask task = new AsyncRecipeChoiceTask();
        if (addToHistory) {
            profile.getGuideHistory().add(item);
        }
        ItemStack result = item.getRecipeOutput();
        RecipeType recipeType = item.getRecipeType();
        ItemStack[] recipe = item.getRecipe();
        this.displayItem(menu, profile, p, item, result, recipeType, recipe, task);
        if (item instanceof RecipeDisplayItem) {
            RecipeDisplayItem recipeDisplayItem = (RecipeDisplayItem)((Object)item);
            this.displayRecipes(p, profile, menu, recipeDisplayItem, 0);
        }
        menu.open(p);
        if (!task.isEmpty()) {
            task.start(menu.toInventory());
        }
    }

    private void displayItem(ChestMenu menu, PlayerProfile profile, Player p, Object item, ItemStack output, RecipeType recipeType, ItemStack[] recipe, AsyncRecipeChoiceTask task) {
        this.addBackButton(menu, 0, p, profile);
        ChestMenu.MenuClickHandler clickHandler = (pl, slot, itemstack, action) -> {
            try {
                if (itemstack != null && itemstack.getType() != Material.BARRIER) {
                    this.displayItem(profile, itemstack, 0, true);
                }
            }
            catch (Exception | LinkageError x) {
                this.printErrorMessage(pl, x);
            }
            return false;
        };
        boolean isSlimefunRecipe = item instanceof SlimefunItem;
        block0: for (int i = 0; i < 9; ++i) {
            ItemStack recipeItem = SurvivalSlimefunGuide.getDisplayItem(p, isSlimefunRecipe, recipe[i]);
            menu.addItem(this.recipeSlots[i], recipeItem, clickHandler);
            if (recipeItem == null || !(item instanceof MultiBlockMachine)) continue;
            for (Tag<Material> tag : MultiBlock.getSupportedTags()) {
                if (!tag.isTagged((Keyed)recipeItem.getType())) continue;
                task.add(this.recipeSlots[i], tag);
                continue block0;
            }
        }
        menu.addItem(10, recipeType.getItem(p), ChestMenuUtils.getEmptyClickHandler());
        menu.addItem(16, output, ChestMenuUtils.getEmptyClickHandler());
    }

    @ParametersAreNonnullByDefault
    public void createHeader(Player p, PlayerProfile profile, ChestMenu menu) {
        int i;
        Validate.notNull(p, "The Player cannot be null!");
        Validate.notNull(profile, "The Profile cannot be null!");
        Validate.notNull(menu, "The Inventory cannot be null!");
        for (i = 0; i < 9; ++i) {
            menu.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        menu.addItem(1, ChestMenuUtils.getMenuButton(p));
        menu.addMenuClickHandler(1, (pl, slot, item, action) -> {
            SlimefunGuideSettings.openSettings(pl, pl.getInventory().getItemInMainHand());
            return false;
        });
        menu.addItem(7, ChestMenuUtils.getSearchButton(p));
        menu.addMenuClickHandler(7, (pl, slot, item, action) -> {
            pl.closeInventory();
            Slimefun.getLocalization().sendMessage((CommandSender)pl, "guide.search.message");
            ChatInput.waitForPlayer((Plugin)Slimefun.instance(), pl, msg -> SlimefunGuide.openSearch(profile, msg, this.getMode(), this.isSurvivalMode()));
            return false;
        });
        for (i = 45; i < 54; ++i) {
            menu.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
    }

    private void addBackButton(ChestMenu menu, int slot, Player p, PlayerProfile profile) {
        GuideHistory history = profile.getGuideHistory();
        if (this.isSurvivalMode() && history.size() > 1) {
            menu.addItem(slot, new CustomItemStack(ChestMenuUtils.getBackButton(p, "", "&fLeft Click: &7Go back to previous Page", "&fShift + left Click: &7Go back to Main Menu")));
            menu.addMenuClickHandler(slot, (pl, s, is, action) -> {
                if (action.isShiftClicked()) {
                    this.openMainMenu(profile, profile.getGuideHistory().getMainMenuPage());
                } else {
                    history.goBack(this);
                }
                return false;
            });
        } else {
            menu.addItem(slot, new CustomItemStack(ChestMenuUtils.getBackButton(p, "", String.valueOf(ChatColor.GRAY) + Slimefun.getLocalization().getMessage(p, "guide.back.guide"))));
            menu.addMenuClickHandler(slot, (pl, s, is, action) -> {
                this.openMainMenu(profile, profile.getGuideHistory().getMainMenuPage());
                return false;
            });
        }
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    private static ItemStack getDisplayItem(Player p, boolean isSlimefunRecipe, ItemStack item) {
        if (isSlimefunRecipe) {
            SlimefunItem slimefunItem = SlimefunItem.getByItem(item);
            if (slimefunItem == null) {
                return item;
            }
            String lore = SurvivalSlimefunGuide.hasPermission(p, slimefunItem) ? "&fNeeds to be unlocked in " + slimefunItem.getItemGroup().getDisplayName(p) : "&fNo Permission";
            return slimefunItem.canUse(p, false) ? item : new CustomItemStack(Material.BARRIER, ItemUtils.getItemName(item), "&4&l" + Slimefun.getLocalization().getMessage(p, "guide.locked"), "", lore);
        }
        return item;
    }

    @ParametersAreNonnullByDefault
    private void displayRecipes(Player p, PlayerProfile profile, ChestMenu menu, RecipeDisplayItem sfItem, int page) {
        List<ItemStack> recipes = sfItem.getDisplayRecipes();
        if (!recipes.isEmpty()) {
            menu.addItem(53, null);
            if (page == 0) {
                for (int i = 27; i < 36; ++i) {
                    menu.replaceExistingItem(i, new CustomItemStack(ChestMenuUtils.getBackground(), sfItem.getRecipeSectionLabel(p), new String[0]));
                    menu.addMenuClickHandler(i, ChestMenuUtils.getEmptyClickHandler());
                }
            }
            int pages = (recipes.size() - 1) / 18 + 1;
            menu.replaceExistingItem(28, ChestMenuUtils.getPreviousButton(p, page + 1, pages));
            menu.addMenuClickHandler(28, (pl, slot, itemstack, action) -> {
                if (page > 0) {
                    this.displayRecipes(pl, profile, menu, sfItem, page - 1);
                    SoundEffect.GUIDE_BUTTON_CLICK_SOUND.playFor(pl);
                }
                return false;
            });
            menu.replaceExistingItem(34, ChestMenuUtils.getNextButton(p, page + 1, pages));
            menu.addMenuClickHandler(34, (pl, slot, itemstack, action) -> {
                if (recipes.size() > 18 * (page + 1)) {
                    this.displayRecipes(pl, profile, menu, sfItem, page + 1);
                    SoundEffect.GUIDE_BUTTON_CLICK_SOUND.playFor(pl);
                }
                return false;
            });
            int inputs = 36;
            int outputs = 45;
            for (int i = 0; i < 18; ++i) {
                int slot2 = i % 2 == 0 ? inputs++ : outputs++;
                this.addDisplayRecipe(menu, profile, recipes, slot2, i, page);
            }
        }
    }

    private void addDisplayRecipe(ChestMenu menu, PlayerProfile profile, List<ItemStack> recipes, int slot, int i, int page) {
        if (i + page * 18 < recipes.size()) {
            ItemStack displayItem = recipes.get(i + page * 18);
            if (displayItem != null) {
                displayItem = displayItem.clone();
            }
            menu.replaceExistingItem(slot, displayItem);
            if (page == 0) {
                menu.addMenuClickHandler(slot, (pl, s, itemstack, action) -> {
                    this.displayItem(profile, itemstack, 0, true);
                    return false;
                });
            }
        } else {
            menu.replaceExistingItem(slot, null);
            menu.addMenuClickHandler(slot, ChestMenuUtils.getEmptyClickHandler());
        }
    }

    @ParametersAreNonnullByDefault
    private static boolean hasPermission(Player p, SlimefunItem item) {
        return Slimefun.getPermissionsService().hasPermission((Permissible)p, item);
    }

    @Nonnull
    private ChestMenu create(@Nonnull Player p) {
        ChestMenu menu = new ChestMenu(Slimefun.getLocalization().getMessage(p, "guide.title.main"));
        menu.setEmptySlotsClickable(false);
        menu.addMenuOpeningHandler(SoundEffect.GUIDE_BUTTON_CLICK_SOUND::playFor);
        return menu;
    }

    @ParametersAreNonnullByDefault
    private void printErrorMessage(Player p, Throwable x) {
        p.sendMessage(String.valueOf(ChatColor.DARK_RED) + "An internal server error has occurred. Please inform an admin, check the console for further info.");
        Slimefun.logger().log(Level.SEVERE, "An error has occurred while trying to open a SlimefunItem in the guide!", x);
    }

    @ParametersAreNonnullByDefault
    private void printErrorMessage(Player p, SlimefunItem item, Throwable x) {
        p.sendMessage(String.valueOf(ChatColor.DARK_RED) + "An internal server error has occurred. Please inform an admin, check the console for further info.");
        item.error("This item has caused an error message to be thrown while viewing it in the Slimefun guide.", x);
    }
}

