/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.CSCoreLibPlugin.general.Inventory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.MenuListener;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ChestMenu {
    private boolean clickable;
    private boolean emptyClickable;
    private String title;
    private Inventory inv;
    private List<ItemStack> items;
    private Map<Integer, MenuClickHandler> handlers;
    private MenuOpeningHandler open;
    private MenuCloseHandler close;
    private MenuClickHandler playerclick;

    public ChestMenu(String title) {
        this.title = ChatColor.translateAlternateColorCodes((char)'&', (String)title);
        this.clickable = false;
        this.emptyClickable = true;
        this.items = new ArrayList<ItemStack>();
        this.handlers = new HashMap<Integer, MenuClickHandler>();
        this.open = p -> {};
        this.close = p -> {};
        this.playerclick = (p, slot, item, action) -> this.isPlayerInventoryClickable();
    }

    public ChestMenu setPlayerInventoryClickable(boolean clickable) {
        this.clickable = clickable;
        return this;
    }

    public boolean isPlayerInventoryClickable() {
        return this.clickable;
    }

    public ChestMenu setEmptySlotsClickable(boolean emptyClickable) {
        this.emptyClickable = emptyClickable;
        return this;
    }

    public boolean isEmptySlotsClickable() {
        return this.emptyClickable;
    }

    public ChestMenu addPlayerInventoryClickHandler(MenuClickHandler handler) {
        this.playerclick = handler;
        return this;
    }

    public ChestMenu addItem(int slot, ItemStack item) {
        int size = this.items.size();
        if (size > slot) {
            this.items.set(slot, item);
        } else {
            for (int i = 0; i < slot - size; ++i) {
                this.items.add(null);
            }
            this.items.add(item);
        }
        return this;
    }

    public ChestMenu addItem(int slot, ItemStack item, MenuClickHandler clickHandler) {
        this.addItem(slot, item);
        this.addMenuClickHandler(slot, clickHandler);
        return this;
    }

    public ItemStack getItemInSlot(int slot) {
        this.setup();
        return this.inv.getItem(slot);
    }

    public ChestMenu addMenuClickHandler(int slot, MenuClickHandler handler) {
        this.handlers.put(slot, handler);
        return this;
    }

    public ChestMenu addMenuOpeningHandler(MenuOpeningHandler handler) {
        this.open = handler;
        return this;
    }

    public ChestMenu addMenuCloseHandler(MenuCloseHandler handler) {
        this.close = handler;
        return this;
    }

    public ChestMenu build() {
        return this;
    }

    public ItemStack[] getContents() {
        this.setup();
        return this.inv.getContents();
    }

    private void setup() {
        if (this.inv != null) {
            return;
        }
        this.inv = Bukkit.createInventory(null, (int)((int)Math.ceil((float)this.items.size() / 9.0f) * 9), (String)this.title);
        for (int i = 0; i < this.items.size(); ++i) {
            this.inv.setItem(i, this.items.get(i));
        }
    }

    public void reset(boolean update) {
        if (update) {
            this.inv.clear();
        } else {
            this.inv = Bukkit.createInventory(null, (int)((int)Math.ceil((float)this.items.size() / 9.0f) * 9), (String)this.title);
        }
        for (int i = 0; i < this.items.size(); ++i) {
            this.inv.setItem(i, this.items.get(i));
        }
    }

    public void replaceExistingItem(int slot, ItemStack item) {
        this.setup();
        this.inv.setItem(slot, item);
    }

    public void open(Player ... players) {
        this.setup();
        for (Player p : players) {
            p.openInventory(this.inv);
            MenuListener.menus.put(p.getUniqueId(), this);
            if (this.open == null) continue;
            this.open.onOpen(p);
        }
    }

    public MenuClickHandler getMenuClickHandler(int slot) {
        return this.handlers.get(slot);
    }

    public MenuCloseHandler getMenuCloseHandler() {
        return this.close;
    }

    public MenuOpeningHandler getMenuOpeningHandler() {
        return this.open;
    }

    public MenuClickHandler getPlayerInventoryClickHandler() {
        return this.playerclick;
    }

    public Inventory toInventory() {
        return this.inv;
    }

    @FunctionalInterface
    public static interface MenuOpeningHandler {
        public void onOpen(Player var1);
    }

    @FunctionalInterface
    public static interface MenuCloseHandler {
        public void onClose(Player var1);
    }

    @FunctionalInterface
    public static interface MenuClickHandler {
        public boolean onClick(Player var1, int var2, ItemStack var3, ClickAction var4);
    }

    public static interface AdvancedMenuClickHandler
    extends MenuClickHandler {
        public boolean onClick(InventoryClickEvent var1, Player var2, int var3, ItemStack var4, ClickAction var5);
    }
}

