/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.utils;

import io.github.thebusybiscuit.slimefun4.utils.tags.SlimefunTag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.inventory.ItemStack;

public class RecipeUtils {
    @ParametersAreNonnullByDefault
    public static <T> BoundingBox calculateBoundingBox(List<T> items, int width, int height) {
        return RecipeUtils.calculateBoundingBox(items, width, height, t -> t == null);
    }

    @ParametersAreNonnullByDefault
    public static <T> BoundingBox calculateBoundingBox(List<T> items, int width, int height, Predicate<T> isEmpty) {
        int left = width - 1;
        int right = 0;
        int top = height - 1;
        int bottom = 0;
        boolean fullyEmpty = true;
        for (int i = 0; i < items.size(); ++i) {
            int x = i % width;
            int y = i / width;
            if (isEmpty.test(items.get(i))) continue;
            fullyEmpty = false;
            if (left > x) {
                left = x;
            }
            if (right < x) {
                right = x;
            }
            if (top > y) {
                top = y;
            }
            if (bottom >= y) continue;
            bottom = y;
        }
        if (fullyEmpty) {
            return new BoundingBox(0, 0, 0, 0);
        }
        return new BoundingBox(top, left, bottom, right);
    }

    public static <T> List<T> flipY(List<T> items, int width, int height) {
        ArrayList<Object> flipped = new ArrayList<Object>(Collections.nCopies(width * height, null));
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int i = y * width + x;
                Object item = i < items.size() ? (Object)items.get(i) : null;
                flipped.set(y * width + (width - 1 - x), item);
            }
        }
        return flipped;
    }

    public static <T> List<T> rotate45deg3x3(List<T> items) {
        if (items.size() < 9) {
            ArrayList<T> temp = new ArrayList<T>(9);
            for (T t : items) {
                temp.add(t);
            }
            items = temp;
        }
        ArrayList<Object> rotated = new ArrayList<Object>(Collections.nCopies(9, null));
        rotated.set(0, items.get(3));
        rotated.set(1, items.get(0));
        rotated.set(2, items.get(1));
        rotated.set(3, items.get(6));
        rotated.set(4, items.get(4));
        rotated.set(5, items.get(2));
        rotated.set(6, items.get(7));
        rotated.set(7, items.get(8));
        rotated.set(8, items.get(5));
        return rotated;
    }

    public static int hashItemsIgnoreAmount(ItemStack[] items) {
        return RecipeUtils.hashItemsIgnoreAmount(Arrays.stream(items).toList());
    }

    public static int hashItemsIgnoreAmount(@Nonnull Iterable<ItemStack> items) {
        int hash = 1;
        for (ItemStack item : items) {
            if (item == null || item.getType().isAir()) {
                hash *= 31;
                continue;
            }
            hash = hash * 31 + item.getType().hashCode();
            hash = hash * 31 + (item.hasItemMeta() ? item.getItemMeta().hashCode() : 0);
        }
        return hash;
    }

    public static Optional<Tag<Material>> tagFromString(String string) {
        if (string == null) {
            return Optional.empty();
        }
        String[] split = string.split(":");
        if (split.length != 2) {
            return Optional.empty();
        }
        return RecipeUtils.tagFromString(split[0], split[1]);
    }

    public static Optional<Tag<Material>> tagFromString(String namespace, String id) {
        if (namespace == null || id == null) {
            return Optional.empty();
        }
        if (namespace.equals("minecraft")) {
            Tag tag = Bukkit.getTag((String)"items", (NamespacedKey)NamespacedKey.minecraft((String)id), Material.class);
            return tag == null ? Optional.empty() : Optional.of(tag);
        }
        if (namespace.equals("slimefun")) {
            SlimefunTag tag = SlimefunTag.getTag(id.toUpperCase());
            return tag == null ? Optional.empty() : Optional.of(tag);
        }
        return Optional.empty();
    }

    public static char getKeyCharByNumber(int i) {
        if (i < 0) {
            return ' ';
        }
        if (i < 9) {
            return (char)(49 + i);
        }
        if (i < 35) {
            return (char)(65 + i - 9);
        }
        if (i < 61) {
            return (char)(97 + i - 35);
        }
        if (i < 77) {
            return (char)(33 + i - 61);
        }
        if (i < 84) {
            return (char)(58 + i - 77);
        }
        if (i < 90) {
            return (char)(91 + i - 84);
        }
        if (i < 94) {
            return (char)(123 + i - 90);
        }
        return ' ';
    }

    public static class BoundingBox {
        public final int top;
        public final int left;
        public final int bottom;
        public final int right;

        public BoundingBox(int top, int left, int bottom, int right) {
            this.top = top;
            this.left = left;
            this.bottom = bottom;
            this.right = right;
        }

        public String toString() {
            return "(" + this.top + ", " + this.left + ", " + this.bottom + ", " + this.right + ")";
        }

        public int getWidth() {
            return this.right - this.left + 1;
        }

        public int getHeight() {
            return this.bottom - this.top + 1;
        }

        public boolean isSameShape(BoundingBox other) {
            return this.getWidth() == other.getWidth() && this.getHeight() == other.getHeight();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            BoundingBox box = (BoundingBox)obj;
            return box.top == this.top && box.left == this.left && box.bottom == this.bottom && box.right == this.right;
        }
    }
}

