/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.tasks;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.TeleporterListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.WorldListener;
import io.github.thebusybiscuit.slimefun4.implementation.setup.PostSetup;
import io.github.thebusybiscuit.slimefun4.implementation.setup.RecipeSetup;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Bukkit;
import org.bukkit.World;

public class SlimefunStartupTask
implements Runnable {
    private final Slimefun plugin;
    private final Runnable runnable;

    public SlimefunStartupTask(@Nonnull Slimefun plugin, @Nonnull Runnable runnable) {
        this.plugin = plugin;
        this.runnable = runnable;
    }

    @Override
    public void run() {
        this.runnable.run();
        PostSetup.loadItems();
        Slimefun.logger().info("Loading recipes...");
        RecipeSetup.setup();
        Slimefun.getWorldSettingsService().load(Bukkit.getWorlds());
        for (World world : Bukkit.getWorlds()) {
            try {
                new BlockStorage(world);
            }
            catch (Exception x) {
                Slimefun.logger().log(Level.SEVERE, x, () -> "An Error occurred while trying to load World \"" + world.getName() + "\" for Slimefun v" + Slimefun.getVersion());
            }
        }
        new WorldListener(this.plugin);
        if (this.isEnabled("ELEVATOR_PLATE", "GPS_ACTIVATION_DEVICE_SHARED", "GPS_ACTIVATION_DEVICE_PERSONAL")) {
            new TeleporterListener(this.plugin);
        }
    }

    private boolean isEnabled(String ... itemIds) {
        for (String id : itemIds) {
            SlimefunItem item = SlimefunItem.getById(id);
            if (item == null || item.isDisabled()) continue;
            return true;
        }
        return false;
    }
}

