/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import io.github.thebusybiscuit.slimefun4.api.recipes.AbstractRecipeInput;
import io.github.thebusybiscuit.slimefun4.api.recipes.AbstractRecipeOutput;
import io.github.thebusybiscuit.slimefun4.api.recipes.Recipe;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.AbstractRecipeInputItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.AbstractRecipeOutputItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.json.CustomRecipeDeserializer;
import io.github.thebusybiscuit.slimefun4.api.recipes.json.RecipeInputItemSerDes;
import io.github.thebusybiscuit.slimefun4.api.recipes.json.RecipeInputSerDes;
import io.github.thebusybiscuit.slimefun4.api.recipes.json.RecipeOutputItemSerDes;
import io.github.thebusybiscuit.slimefun4.api.recipes.json.RecipeOutputSerDes;
import io.github.thebusybiscuit.slimefun4.api.recipes.json.RecipeSerDes;
import io.github.thebusybiscuit.slimefun4.api.recipes.matching.MatchProcedure;
import io.github.thebusybiscuit.slimefun4.api.recipes.matching.RecipeMatchResult;
import io.github.thebusybiscuit.slimefun4.api.recipes.matching.RecipeSearchResult;
import io.github.thebusybiscuit.slimefun4.utils.RecipeUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class RecipeService {
    public static final String SAVED_RECIPE_DIR = "plugins/Slimefun/recipes/";
    public static final String BACKUP_RECIPE_DIR = "plugins/Slimefun/recipe-backups/";
    private Plugin plugin;
    private Gson gson;
    private final Map<NamespacedKey, CustomRecipeDeserializer<AbstractRecipeInputItem>> customRIItemDeserializers = new HashMap<NamespacedKey, CustomRecipeDeserializer<AbstractRecipeInputItem>>();
    private final Map<NamespacedKey, CustomRecipeDeserializer<AbstractRecipeInput>> customRInputDeserializers = new HashMap<NamespacedKey, CustomRecipeDeserializer<AbstractRecipeInput>>();
    private final Map<NamespacedKey, CustomRecipeDeserializer<AbstractRecipeOutputItem>> customROItemDeserializers = new HashMap<NamespacedKey, CustomRecipeDeserializer<AbstractRecipeOutputItem>>();
    private final Map<NamespacedKey, CustomRecipeDeserializer<AbstractRecipeOutput>> customROutputDeserializers = new HashMap<NamespacedKey, CustomRecipeDeserializer<AbstractRecipeOutput>>();
    private final Map<NamespacedKey, CustomRecipeDeserializer<Recipe>> customRecipeDeserializers = new HashMap<NamespacedKey, CustomRecipeDeserializer<Recipe>>();
    private final Map<NamespacedKey, MatchProcedure> matchProcedures = new HashMap<NamespacedKey, MatchProcedure>();
    private final Map<String, ItemStack> emptyItems = new HashMap<String, ItemStack>();
    private final Map<String, Recipe> recipesById = new HashMap<String, Recipe>();
    private final Map<String, Set<Recipe>> recipesByFilename = new HashMap<String, Set<Recipe>>();
    private final Set<String> filesRead = new HashSet<String>();
    private final Map<RecipeType, Set<Recipe>> recipesByType = new HashMap<RecipeType, Set<Recipe>>();
    private final Set<String> recipeOverrides = new HashSet<String>();
    private int maxCacheEntries = 1000;
    private boolean allRecipesLoaded = false;
    private final Map<Integer, Recipe> recipeCache = new LinkedHashMap<Integer, Recipe>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, Recipe> eldest) {
            return this.size() > RecipeService.this.maxCacheEntries;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecipeService(@Nonnull Plugin plugin) {
        this.plugin = plugin;
        this.registerMatchProcedure(MatchProcedure.SHAPED);
        this.registerMatchProcedure(MatchProcedure.SHAPED_FLIPPABLE);
        this.registerMatchProcedure(MatchProcedure.SHAPED_ROTATABLE_45_3X3);
        this.registerMatchProcedure(MatchProcedure.SHAPELESS);
        this.registerMatchProcedure(MatchProcedure.SUBSET);
        this.gson = new GsonBuilder().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().registerTypeAdapter(Recipe.class, (Object)new RecipeSerDes()).registerTypeAdapter(AbstractRecipeInput.class, (Object)new RecipeInputSerDes()).registerTypeAdapter(AbstractRecipeOutput.class, (Object)new RecipeOutputSerDes()).registerTypeAdapter(AbstractRecipeInputItem.class, (Object)new RecipeInputItemSerDes()).registerTypeAdapter(AbstractRecipeOutputItem.class, (Object)new RecipeOutputItemSerDes()).create();
        try (BufferedReader reader = new BufferedReader(new FileReader("plugins/Slimefun/recipe-overrides"));){
            String line = reader.readLine();
            while (line != null) {
                this.recipeOverrides.add(line);
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            plugin.getLogger().warning("Could not load recipe overrides: " + e.getLocalizedMessage());
        }
        finally {
            this.allRecipesLoaded = true;
        }
    }

    public boolean addRecipeOverride(String override, String ... filenames) {
        if (this.allRecipesLoaded) {
            this.plugin.getLogger().warning("Recipes were already loaded, so the recipe override '" + override + "' was not processed!");
            return false;
        }
        if (this.recipeOverrides.contains(override)) {
            return false;
        }
        for (String filename : filenames) {
            File file = new File(SAVED_RECIPE_DIR + filename + ".json");
            if (file.isFile()) {
                try {
                    boolean deleted = file.delete();
                    if (deleted) continue;
                    this.plugin.getLogger().severe("Could not delete file '" + filename + "' for recipe override '" + override + "'");
                    return false;
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("An error occurred when applying recipe override '" + override + "' to file '" + filename + "': " + e.getLocalizedMessage());
                    return false;
                }
            }
            this.plugin.getLogger().warning("Skipping file '" + filename + "' for recipe override '" + override + "' because it is a directory");
        }
        this.recipeOverrides.add(override);
        return true;
    }

    public void registerMatchProcedure(MatchProcedure m) {
        this.matchProcedures.put(m.getKey(), m);
    }

    @Nonnull
    public Set<Recipe> getRecipesByType(RecipeType type) {
        Set<Recipe> set = this.recipesByType.get(type);
        return set == null ? Collections.emptySet() : Collections.unmodifiableSet(set);
    }

    public void addRecipeToType(Recipe recipe, RecipeType type) {
        if (!this.recipesByType.containsKey(type)) {
            this.recipesByType.put(type, new HashSet());
        }
        this.recipesByType.get(type).add(recipe);
    }

    @Nullable
    public Recipe getRecipe(String id) {
        return this.recipesById.get(id);
    }

    public void addRecipe(Recipe recipe, boolean forceId, boolean forceFilename) {
        if (recipe.getId().isPresent()) {
            String id = recipe.getId().get();
            if (this.recipesById.containsKey(id) && !forceId) {
                this.plugin.getLogger().warning("A recipe with id " + id + " already exists!");
            } else {
                if (forceId && this.recipesById.containsKey(id)) {
                    Recipe old = this.recipesById.get(id);
                    this.removeRecipeFromFilename(old);
                    this.removeRecipeFromTypes(old);
                    this.recipeCache.clear();
                }
                this.recipesById.put(id, recipe);
            }
        }
        if (!this.recipesByFilename.containsKey(recipe.getFilename())) {
            LinkedHashSet<Recipe> newList = new LinkedHashSet<Recipe>();
            newList.add(recipe);
            this.recipesByFilename.put(recipe.getFilename(), newList);
        } else if (forceFilename || !this.filesRead.contains(recipe.getFilename())) {
            this.recipesByFilename.get(recipe.getFilename()).add(recipe);
        }
        recipe.getTypes().forEach(type -> this.addRecipeToType(recipe, (RecipeType)type));
    }

    public void addRecipe(Recipe recipe) {
        this.addRecipe(recipe, false, false);
    }

    private void removeRecipeFromId(Recipe recipe) {
        if (recipe.getId().isPresent()) {
            this.recipesById.remove(recipe.getId().get());
        }
    }

    private void removeRecipeFromTypes(Recipe recipe) {
        for (RecipeType type : recipe.getTypes()) {
            this.recipesByType.get(type).remove(recipe);
        }
    }

    private void removeRecipeFromFilename(Recipe recipe) {
        this.recipesByFilename.get(recipe.getFilename()).remove(recipe);
    }

    public Set<Recipe> getRecipesByFilename(String filename) {
        Set<Recipe> set = this.recipesByFilename.get(filename);
        return set == null ? Collections.emptySet() : Collections.unmodifiableSet(set);
    }

    @Nullable
    public Recipe getCachedRecipe(List<ItemStack> givenItems) {
        return this.recipeCache.get(RecipeUtils.hashItemsIgnoreAmount(givenItems));
    }

    @Nullable
    public Recipe getCachedRecipe(int hash) {
        return this.recipeCache.get(hash);
    }

    public void cacheRecipe(Recipe recipe, List<ItemStack> givenItems) {
        this.cacheRecipe(recipe, RecipeUtils.hashItemsIgnoreAmount(givenItems));
    }

    public void cacheRecipe(Recipe recipe, int hash) {
        this.recipeCache.put(hash, recipe);
    }

    public RecipeSearchResult searchRecipes(RecipeType type, Function<Recipe, RecipeMatchResult> recipeIsMatch, int hash) {
        RecipeMatchResult result;
        Recipe cachedRecipe = this.getCachedRecipe(hash);
        if (cachedRecipe != null && cachedRecipe.getTypes().contains(type) && (result = recipeIsMatch.apply(cachedRecipe)).itemsMatch()) {
            return new RecipeSearchResult(result);
        }
        Set<Recipe> recipes = this.getRecipesByType(type);
        for (Recipe recipe : recipes) {
            RecipeMatchResult matchResult = recipeIsMatch.apply(recipe);
            if (!matchResult.itemsMatch()) continue;
            this.cacheRecipe(recipe, hash);
            return new RecipeSearchResult(matchResult);
        }
        return new RecipeSearchResult();
    }

    public RecipeSearchResult searchRecipes(RecipeType type, List<ItemStack> givenItems, MatchProcedure matchAs) {
        return this.searchRecipes(type, (Recipe recipe) -> recipe.matchAs(matchAs, givenItems), RecipeUtils.hashItemsIgnoreAmount(givenItems));
    }

    public RecipeSearchResult searchRecipes(RecipeType type, List<ItemStack> givenItems) {
        return this.searchRecipes(type, (Recipe recipe) -> recipe.match(givenItems), RecipeUtils.hashItemsIgnoreAmount(givenItems));
    }

    public RecipeSearchResult searchRecipes(Collection<RecipeType> types, Function<Recipe, RecipeMatchResult> recipeIsMatch, int hash) {
        for (RecipeType type : types) {
            RecipeSearchResult result = this.searchRecipes(type, recipeIsMatch, hash);
            if (!result.matchFound()) continue;
            return result;
        }
        return new RecipeSearchResult();
    }

    public RecipeSearchResult searchRecipes(Collection<RecipeType> types, List<ItemStack> givenItems, MatchProcedure matchAs) {
        return this.searchRecipes(types, (Recipe recipe) -> recipe.matchAs(matchAs, givenItems), RecipeUtils.hashItemsIgnoreAmount(givenItems));
    }

    public RecipeSearchResult searchRecipes(Collection<RecipeType> types, List<ItemStack> givenItems) {
        return this.searchRecipes(types, (Recipe recipe) -> recipe.match(givenItems), RecipeUtils.hashItemsIgnoreAmount(givenItems));
    }

    @Nullable
    public MatchProcedure getMatchProcedure(@Nonnull NamespacedKey key) {
        return this.matchProcedures.get(key);
    }

    public boolean registerMatchProcedure(NamespacedKey key, MatchProcedure match) {
        if (this.matchProcedures.containsKey(key)) {
            return false;
        }
        this.matchProcedures.put(key, match);
        return true;
    }

    public ItemStack getEmptyItem(String id) {
        return this.emptyItems.get(id);
    }

    public void addEmptyItem(String id, ItemStack empty) {
        this.emptyItems.put(id, empty);
    }

    public CustomRecipeDeserializer<AbstractRecipeInputItem> getRecipeInputItemDeserializer(@Nonnull NamespacedKey key) {
        return this.customRIItemDeserializers.get(key);
    }

    public CustomRecipeDeserializer<AbstractRecipeInput> getRecipeInputDeserializer(@Nonnull NamespacedKey key) {
        return this.customRInputDeserializers.get(key);
    }

    public CustomRecipeDeserializer<AbstractRecipeOutputItem> getRecipeOutputItemDeserializer(@Nonnull NamespacedKey key) {
        return this.customROItemDeserializers.get(key);
    }

    public CustomRecipeDeserializer<AbstractRecipeOutput> getRecipeOutputDeserializer(@Nonnull NamespacedKey key) {
        return this.customROutputDeserializers.get(key);
    }

    public CustomRecipeDeserializer<Recipe> getRecipeDeserializer(@Nonnull NamespacedKey key) {
        return this.customRecipeDeserializers.get(key);
    }

    @ParametersAreNonnullByDefault
    public void addRecipeInputItemDeserializer(NamespacedKey key, CustomRecipeDeserializer<AbstractRecipeInputItem> des) {
        this.customRIItemDeserializers.put(key, des);
    }

    @ParametersAreNonnullByDefault
    public void addRecipeInputDeserializer(NamespacedKey key, CustomRecipeDeserializer<AbstractRecipeInput> des) {
        this.customRInputDeserializers.put(key, des);
    }

    @ParametersAreNonnullByDefault
    public void addRecipeOutputItemDeserializer(NamespacedKey key, CustomRecipeDeserializer<AbstractRecipeOutputItem> des) {
        this.customROItemDeserializers.put(key, des);
    }

    @ParametersAreNonnullByDefault
    public void addRecipeOutputDeserializer(NamespacedKey key, CustomRecipeDeserializer<AbstractRecipeOutput> des) {
        this.customROutputDeserializers.put(key, des);
    }

    @ParametersAreNonnullByDefault
    public void addRecipeDeserializer(NamespacedKey key, CustomRecipeDeserializer<Recipe> des) {
        this.customRecipeDeserializers.put(key, des);
    }

    public Recipe parseRecipeString(String s) {
        return (Recipe)this.gson.fromJson(s, Recipe.class);
    }

    private Set<String> getAllRecipeFilenames(String directory, String subdirectory) {
        Set<String> set;
        block9: {
            Path dir = Path.of(directory, subdirectory);
            if (!dir.toFile().exists()) {
                return Collections.emptySet();
            }
            Stream<Path> files = Files.walk(dir, new FileVisitOption[0]);
            try {
                set = files.filter(f -> f.toString().endsWith(".json")).map(file -> {
                    String filename = dir.relativize((Path)file).toString();
                    return filename.substring(0, filename.length() - 5);
                }).collect(Collectors.toSet());
                if (files == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return Collections.emptySet();
                }
            }
            files.close();
        }
        return set;
    }

    public Set<String> getAllRecipeFilenames(String subdirectory) {
        return this.getAllRecipeFilenames(SAVED_RECIPE_DIR, subdirectory);
    }

    public Set<String> getAllRecipeFilenames() {
        return this.getAllRecipeFilenames("");
    }

    public void loadAllRecipes() {
        this.getAllRecipeFilenames().forEach(this::loadRecipesFromFile);
        this.allRecipesLoaded = true;
    }

    public List<Recipe> loadRecipesFromFile(String filename) {
        return this.loadRecipesFromFile(filename, this.gson);
    }

    public List<Recipe> loadRecipesFromFile(String filename, Gson gson) {
        List<Object> recipes = new ArrayList();
        if (this.recipesByFilename.containsKey(filename)) {
            for (Recipe recipe : this.recipesByFilename.get(filename)) {
                this.removeRecipeFromId(recipe);
                this.removeRecipeFromTypes(recipe);
                this.recipeCache.clear();
            }
            this.recipesByFilename.get(filename).clear();
        }
        try (FileReader fileReader = new FileReader(new File(SAVED_RECIPE_DIR + filename + ".json"));){
            JsonElement obj = (JsonElement)gson.fromJson((Reader)fileReader, JsonElement.class);
            if (obj.isJsonArray()) {
                JsonArray jsonRecipes = obj.getAsJsonArray();
                recipes = new ArrayList();
                for (JsonElement jsonRecipe : jsonRecipes) {
                    JsonObject recipe = jsonRecipe.getAsJsonObject();
                    recipe.addProperty("__filename", filename);
                    recipes.add((Recipe)gson.fromJson((JsonElement)recipe, Recipe.class));
                }
            } else {
                JsonObject recipe = obj.getAsJsonObject();
                recipe.addProperty("__filename", filename);
                recipes.add((Recipe)gson.fromJson(obj, Recipe.class));
            }
            this.filesRead.add(filename);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Could not load recipe file '" + filename + "': " + e.getLocalizedMessage());
            recipes = Collections.emptyList();
        }
        catch (NullPointerException e) {
            this.plugin.getLogger().warning("Could not load recipe file '" + filename + "': " + e.getLocalizedMessage());
            recipes = Collections.emptyList();
        }
        recipes.forEach(r -> this.addRecipe((Recipe)r, true, true));
        return recipes;
    }

    public boolean areAllRecipesLoaded() {
        return this.allRecipesLoaded;
    }

    public void saveAllRecipes() {
        for (Map.Entry<String, Set<Recipe>> entry : this.recipesByFilename.entrySet()) {
            String filename = entry.getKey();
            Set<Recipe> recipes = entry.getValue();
            try (FileWriter writer = new FileWriter(SAVED_RECIPE_DIR + filename + ".json");){
                JsonWriter jsonWriter = this.gson.newJsonWriter((Writer)writer);
                jsonWriter.setIndent("    ");
                if (recipes.size() == 1) {
                    this.gson.toJson(recipes.stream().findFirst().get(), Recipe.class, jsonWriter);
                    continue;
                }
                this.gson.toJson(recipes, List.class, jsonWriter);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Couldn't save recipe to '" + filename + "': " + e.getLocalizedMessage());
            }
        }
    }

    private void copyRecipeFiles(String sourceDir, String targetDir, boolean clean) {
        try (Stream<Path> target = Files.list(Path.of(targetDir, new String[0]));){
            Set<String> filenames = this.getAllRecipeFilenames(sourceDir, "");
            target.forEach(p -> {
                if (clean || filenames.contains(Path.of(targetDir, new String[0]).relativize((Path)p).toString())) {
                    p.toFile().delete();
                }
            });
            this.getAllRecipeFilenames(sourceDir, "").forEach(source -> {
                Path destination = Paths.get(targetDir, source + ".json");
                Path parent = destination.getParent();
                if (parent != null && !parent.toFile().exists()) {
                    parent.toFile().mkdirs();
                }
                try {
                    Files.copy(Path.of(sourceDir, source + ".json"), destination, new CopyOption[0]);
                }
                catch (IOException e) {
                    this.plugin.getLogger().warning("Couldn't copy recipe from '" + source + "' to '" + targetDir + "'");
                }
            });
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Couldn't copy recipes from '" + sourceDir + "' to '" + targetDir + "'");
        }
    }

    public void backUpRecipeFiles() {
        this.copyRecipeFiles(SAVED_RECIPE_DIR, BACKUP_RECIPE_DIR, true);
    }

    public void restoreBackupRecipeFiles() {
        this.copyRecipeFiles(BACKUP_RECIPE_DIR, SAVED_RECIPE_DIR, false);
    }

    public void clear() {
        this.recipesByFilename.clear();
        this.recipesById.clear();
        this.recipesByType.clear();
        this.filesRead.clear();
        this.recipeCache.clear();
    }

    public void deleteRecipeFiles() {
        try (Stream<Path> target = Files.list(Path.of(SAVED_RECIPE_DIR, new String[0]));){
            target.forEach(p -> p.toFile().delete());
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Couldn't delete recipe files");
        }
    }
}

