/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.recipes.matching;

import io.github.thebusybiscuit.slimefun4.api.recipes.AbstractRecipeInput;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.AbstractRecipeInputItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.matching.InputMatchResult;
import io.github.thebusybiscuit.slimefun4.api.recipes.matching.ItemMatchResult;
import io.github.thebusybiscuit.slimefun4.utils.RecipeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;

public abstract class MatchProcedure {
    public static final MatchProcedure DUMMY = new MatchProcedure("slimefun:dummy"){

        @Override
        public InputMatchResult match(AbstractRecipeInput recipeInput, List<ItemStack> givenItems) {
            return InputMatchResult.noMatch(recipeInput);
        }
    };
    public static final MatchProcedure EMPTY = new MatchProcedure("slimefun:empty"){

        @Override
        public InputMatchResult match(AbstractRecipeInput recipeInput, List<ItemStack> givenItems) {
            return new InputMatchResult(recipeInput, Collections.emptyList(), true);
        }
    };
    public static final MatchProcedure SHAPED = new MatchProcedure("slimefun:shaped"){

        @Override
        public InputMatchResult match(AbstractRecipeInput recipeInput, List<ItemStack> givenItems) {
            RecipeUtils.BoundingBox givenBox;
            int width = recipeInput.getWidth();
            int height = recipeInput.getHeight();
            Optional<RecipeUtils.BoundingBox> oRecipeBox = recipeInput.getBoundingBox();
            if (oRecipeBox.isEmpty()) {
                return InputMatchResult.noMatch(recipeInput);
            }
            RecipeUtils.BoundingBox recipeBox = oRecipeBox.get();
            if (!recipeBox.isSameShape(givenBox = RecipeUtils.calculateBoundingBox(givenItems, width, height, i -> i == null || i.getType().isAir()))) {
                return InputMatchResult.noMatch(recipeInput);
            }
            ArrayList<ItemMatchResult> results = new ArrayList<ItemMatchResult>();
            for (int i2 = 0; i2 < recipeBox.getWidth() * recipeBox.getHeight(); ++i2) {
                int recipeX = recipeBox.left + i2 % recipeBox.getWidth();
                int recipeY = recipeBox.top + i2 / recipeBox.getWidth();
                int givenX = givenBox.left + i2 % givenBox.getWidth();
                int givenY = givenBox.top + i2 / givenBox.getWidth();
                AbstractRecipeInputItem recipeItem = recipeInput.getItem(recipeY * width + recipeX);
                ItemStack givenItem = givenItems.get(givenY * width + givenX);
                ItemMatchResult matchResult = recipeItem.matchItem(givenItem);
                results.add(matchResult);
                if (matchResult.itemsMatch()) continue;
                return new InputMatchResult(recipeInput, results, false);
            }
            return new InputMatchResult(recipeInput, results, true);
        }
    };
    public static final MatchProcedure SHAPED_FLIPPABLE = new MatchProcedure("slimefun:shaped_flippable"){

        @Override
        public InputMatchResult match(AbstractRecipeInput recipeInput, List<ItemStack> givenItems) {
            InputMatchResult result = SHAPED.match(recipeInput, givenItems);
            if (result.itemsMatch()) {
                return result;
            }
            List<ItemStack> flipped = RecipeUtils.flipY(givenItems, recipeInput.getWidth(), recipeInput.getHeight());
            return SHAPED.match(recipeInput, flipped);
        }
    };
    public static final MatchProcedure SHAPED_ROTATABLE_45_3X3 = new MatchProcedure("slimefun:shaped_rotatable_3x3"){

        @Override
        public InputMatchResult match(AbstractRecipeInput recipeInput, List<ItemStack> givenItems) {
            InputMatchResult result = null;
            for (int i = 0; i < 8; ++i) {
                result = SHAPED.match(recipeInput, givenItems);
                if (result.itemsMatch() || i == 7) {
                    return result;
                }
                givenItems = RecipeUtils.rotate45deg3x3(givenItems);
            }
            return result;
        }
    };
    public static final MatchProcedure SUBSET = new MatchProcedure("slimefun:subset"){

        @Override
        public InputMatchResult match(AbstractRecipeInput recipeInput, List<ItemStack> givenItems) {
            if (recipeInput.getItems().stream().filter(i -> !i.isEmpty()).count() > givenItems.stream().filter(i -> i != null && !i.getType().isAir()).count()) {
                return InputMatchResult.noMatch(recipeInput);
            }
            HashMap<Integer, ItemMatchResult> matchedItems = new HashMap<Integer, ItemMatchResult>();
            block0: for (AbstractRecipeInputItem recipeItem : recipeInput.getItems()) {
                if (recipeItem.isEmpty()) continue;
                for (int i2 = 0; i2 < givenItems.size(); ++i2) {
                    ItemMatchResult result;
                    if (matchedItems.containsKey(i2) || !(result = recipeItem.matchItem(givenItems.get(i2))).itemsMatch()) continue;
                    matchedItems.put(i2, result);
                    continue block0;
                }
                return new InputMatchResult(recipeInput, List.copyOf(matchedItems.values()), false);
            }
            return new InputMatchResult(recipeInput, List.copyOf(matchedItems.values()), true);
        }
    };
    public static final MatchProcedure SHAPELESS = new MatchProcedure("slimefun:shapeless"){

        @Override
        public InputMatchResult match(AbstractRecipeInput recipeInput, List<ItemStack> givenItems) {
            if (recipeInput.getItems().stream().filter(i -> !i.isEmpty()).count() != givenItems.stream().filter(i -> i != null && !i.getType().isAir()).count()) {
                return InputMatchResult.noMatch(recipeInput);
            }
            return SUBSET.match(recipeInput, givenItems);
        }
    };
    private final NamespacedKey key;

    public MatchProcedure(String key) {
        this.key = NamespacedKey.fromString((String)key);
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public abstract InputMatchResult match(AbstractRecipeInput var1, List<ItemStack> var2);

    public InputMatchResult match(AbstractRecipeInput recipeInput, ItemStack[] givenItems) {
        return this.match(recipeInput, List.of(givenItems));
    }

    public boolean recipeShouldSaveBoundingBox() {
        return true;
    }

    public String toString() {
        return this.key.toString();
    }
}

