/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.recipes.matching;

import io.github.thebusybiscuit.slimefun4.api.recipes.AbstractRecipeInput;
import io.github.thebusybiscuit.slimefun4.api.recipes.matching.ItemMatchResult;
import java.util.Collections;
import java.util.List;
import org.bukkit.inventory.ItemStack;

public class InputMatchResult {
    private final AbstractRecipeInput input;
    private final List<ItemMatchResult> itemMatchResults;
    private final boolean itemsMatch;
    private int possibleCrafts;

    public InputMatchResult(AbstractRecipeInput input, List<ItemMatchResult> itemMatchResults, boolean itemsMatch) {
        this.input = input;
        this.itemMatchResults = itemMatchResults;
        this.itemsMatch = itemsMatch;
        this.possibleCrafts = Integer.MAX_VALUE;
        for (ItemMatchResult res : itemMatchResults) {
            ItemStack item = res.getMatchedItem();
            if (item == null || res.getRecipeItem().isEmpty()) continue;
            this.possibleCrafts = Math.min(this.possibleCrafts, item.getAmount() / res.getConsumeAmount());
        }
    }

    public InputMatchResult(AbstractRecipeInput input, List<ItemMatchResult> itemMatchResults) {
        this(input, itemMatchResults, itemMatchResults.stream().allMatch(r -> r.itemsMatch()));
    }

    public static InputMatchResult noMatch(AbstractRecipeInput input) {
        return new InputMatchResult(input, Collections.emptyList()){

            @Override
            public boolean itemsMatch() {
                return false;
            }
        };
    }

    public AbstractRecipeInput getInput() {
        return this.input;
    }

    public int getPossibleCrafts() {
        return this.possibleCrafts;
    }

    public List<ItemMatchResult> getItemMatchResults() {
        return Collections.unmodifiableList(this.itemMatchResults);
    }

    public boolean itemsMatch() {
        return this.itemsMatch;
    }

    public int consumeItems(int amount) {
        if (this.possibleCrafts == 0 || amount == 0) {
            return 0;
        }
        int amountToCraft = Math.min(this.possibleCrafts, amount);
        for (ItemMatchResult res : this.itemMatchResults) {
            ItemStack item = res.getMatchedItem();
            if (item == null || res.getRecipeItem().isEmpty()) continue;
            item.setAmount(item.getAmount() - amountToCraft * res.getConsumeAmount());
        }
        this.possibleCrafts -= amountToCraft;
        return amountToCraft;
    }
}

