/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.recipes.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.AbstractRecipeOutputItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.RecipeOutputGroup;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.RecipeOutputItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.json.CustomRecipeDeserializer;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.bukkit.NamespacedKey;

public final class RecipeOutputItemSerDes
implements JsonDeserializer<AbstractRecipeOutputItem>,
JsonSerializer<AbstractRecipeOutputItem> {
    public JsonElement serialize(AbstractRecipeOutputItem src, Type typeOfSrc, JsonSerializationContext context) {
        return src.serialize(context);
    }

    public AbstractRecipeOutputItem deserialize(JsonElement el, Type type, JsonDeserializationContext context) throws JsonParseException {
        AbstractRecipeOutputItem outputItem;
        if (el.isJsonPrimitive()) {
            return RecipeOutputItem.fromString(el.getAsString());
        }
        JsonObject obj = el.getAsJsonObject();
        if (obj.has("id")) {
            AbstractRecipeOutputItem aItem = RecipeOutputItem.fromString(obj.getAsJsonPrimitive("id").getAsString());
            if (aItem instanceof RecipeOutputItem) {
                RecipeOutputItem item = (RecipeOutputItem)aItem;
                item.setAmount(obj.getAsJsonPrimitive("amount").getAsInt());
                outputItem = item;
            } else {
                outputItem = aItem;
            }
        } else {
            List<Integer> weights;
            List<AbstractRecipeOutputItem> group = obj.getAsJsonArray("group").asList().stream().map(e -> this.deserialize((JsonElement)e, type, context)).toList();
            if (obj.has("weights")) {
                weights = obj.getAsJsonArray("weights").asList().stream().map(e -> e.getAsInt()).toList();
            } else {
                int[] arr = new int[group.size()];
                Arrays.fill(arr, 1);
                weights = Arrays.stream(arr).boxed().toList();
            }
            outputItem = new RecipeOutputGroup(group, weights);
        }
        if (obj.has("class")) {
            String cl = obj.getAsJsonPrimitive("class").getAsString();
            CustomRecipeDeserializer<AbstractRecipeOutputItem> deserializer = Slimefun.getRecipeService().getRecipeOutputItemDeserializer(NamespacedKey.fromString((String)cl));
            if (deserializer != null) {
                outputItem = deserializer.deserialize(outputItem, obj, context);
            }
        }
        return outputItem;
    }
}

