/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.recipes.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.github.thebusybiscuit.slimefun4.api.recipes.AbstractRecipeInput;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeInput;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.AbstractRecipeInputItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.RecipeInputItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.json.CustomRecipeDeserializer;
import io.github.thebusybiscuit.slimefun4.api.recipes.matching.MatchProcedure;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import org.bukkit.NamespacedKey;

public final class RecipeInputSerDes
implements JsonDeserializer<AbstractRecipeInput>,
JsonSerializer<AbstractRecipeInput> {
    public JsonElement serialize(AbstractRecipeInput src, Type typeOfSrc, JsonSerializationContext context) {
        return src.serialize(context);
    }

    public AbstractRecipeInput deserialize(JsonElement el, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject obj = el.getAsJsonObject();
        String template = "";
        int width = 0;
        int height = 0;
        JsonElement jsonItems = obj.get("items");
        if (jsonItems.isJsonPrimitive()) {
            template = jsonItems.toString();
            width = template.length();
        } else {
            List itemsList = jsonItems.getAsJsonArray().asList();
            StringBuilder builder = new StringBuilder();
            width = 1;
            height = itemsList.size();
            for (JsonElement item : itemsList) {
                String itemString = item.getAsString();
                width = Math.max(width, itemString.length());
                builder.append(itemString);
            }
            template = builder.toString();
        }
        HashMap key = new HashMap();
        JsonObject jsonKey = obj.getAsJsonObject("key");
        jsonKey.entrySet().forEach(e -> key.put(Character.valueOf(((String)e.getKey()).charAt(0)), (AbstractRecipeInputItem)context.deserialize((JsonElement)e.getValue(), AbstractRecipeInputItem.class)));
        MatchProcedure match = obj.has("match") ? Slimefun.getRecipeService().getMatchProcedure(NamespacedKey.fromString((String)obj.getAsJsonPrimitive("match").getAsString())) : null;
        AbstractRecipeInput input = new RecipeInput(template.chars().mapToObj(i -> {
            char c = (char)i;
            if (key.containsKey(Character.valueOf(c))) {
                return (AbstractRecipeInputItem)key.get(Character.valueOf(c));
            }
            return RecipeInputItem.EMPTY;
        }).toList(), match == null ? MatchProcedure.SHAPED : match, width, height);
        if (obj.has("class")) {
            String cl = obj.getAsJsonPrimitive("class").getAsString();
            CustomRecipeDeserializer<AbstractRecipeInput> deserializer = Slimefun.getRecipeService().getRecipeInputDeserializer(NamespacedKey.fromString((String)cl));
            if (deserializer != null) {
                input = deserializer.deserialize(input, obj, context);
            }
        }
        return input;
    }
}

