/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.recipes.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.AbstractRecipeInputItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.RecipeInputGroup;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.RecipeInputItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.RecipeInputTag;
import io.github.thebusybiscuit.slimefun4.api.recipes.json.CustomRecipeDeserializer;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.utils.RecipeUtils;
import java.lang.reflect.Type;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;

public final class RecipeInputItemSerDes
implements JsonDeserializer<AbstractRecipeInputItem>,
JsonSerializer<AbstractRecipeInputItem> {
    public JsonElement serialize(AbstractRecipeInputItem src, Type typeOfSrc, JsonSerializationContext context) {
        return src.serialize(context);
    }

    public AbstractRecipeInputItem deserialize(JsonElement el, Type type, JsonDeserializationContext context) throws JsonParseException {
        AbstractRecipeInputItem inputItem;
        if (el.isJsonPrimitive()) {
            return RecipeInputItem.fromString(el.getAsString());
        }
        JsonObject obj = el.getAsJsonObject();
        if (obj.has("id")) {
            AbstractRecipeInputItem aItem = RecipeInputItem.fromString(obj.getAsJsonPrimitive("id").getAsString());
            if (aItem instanceof RecipeInputItem) {
                RecipeInputItem item = (RecipeInputItem)aItem;
                int amount = 1;
                if (obj.has("amount")) {
                    amount = obj.getAsJsonPrimitive("amount").getAsInt();
                }
                item.setAmount(amount);
                item.setAmount(obj.getAsJsonPrimitive("amount").getAsInt());
                if (obj.has("durability")) {
                    item.setDurabilityCost(obj.getAsJsonPrimitive("durability").getAsInt());
                }
                inputItem = item;
            } else {
                inputItem = aItem;
            }
        } else if (obj.has("group")) {
            inputItem = new RecipeInputGroup(obj.getAsJsonArray("group").asList().stream().map(e -> this.deserialize((JsonElement)e, type, context)).toList());
        } else {
            Optional<Tag<Material>> tag = RecipeUtils.tagFromString(obj.getAsJsonPrimitive("tag").getAsString());
            inputItem = tag.map(t -> new RecipeInputTag((Tag<Material>)t, obj.getAsJsonPrimitive("amount").getAsInt())).orElseGet(() -> RecipeInputItem.EMPTY);
        }
        if (obj.has("class")) {
            String cl = obj.getAsJsonPrimitive("class").getAsString();
            CustomRecipeDeserializer<AbstractRecipeInputItem> deserializer = Slimefun.getRecipeService().getRecipeInputItemDeserializer(NamespacedKey.fromString((String)cl));
            if (deserializer != null) {
                inputItem = deserializer.deserialize(inputItem, obj, context);
            }
        }
        return inputItem;
    }
}

