/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.recipes.items;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.RecipeOutputItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.matching.RecipeMatchResult;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.inventory.ItemStack;

public class RecipeOutputTag
extends RecipeOutputItem {
    private Tag<Material> tag;

    public RecipeOutputTag(Tag<Material> tag, int amount) {
        super(amount);
        this.tag = tag;
    }

    public RecipeOutputTag(Tag<Material> tag) {
        this(tag, 1);
    }

    public Tag<Material> getTag() {
        return this.tag;
    }

    public void setTag(Tag<Material> tag) {
        this.tag = tag;
    }

    @Override
    public boolean matchItem(ItemStack item) {
        return false;
    }

    @Override
    public ItemStack generateOutput(RecipeMatchResult result) {
        Material[] arr = (Material[])this.tag.getValues().toArray(Material[]::new);
        int i = ThreadLocalRandom.current().nextInt(arr.length);
        return new ItemStack(arr[i], this.getAmount());
    }

    @Override
    public String toString() {
        return "ROTag { " + String.valueOf(this.tag) + ", " + super.toString() + " }";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RecipeOutputTag item = (RecipeOutputTag)obj;
        return item.tag.getKey().equals((Object)this.tag.getKey()) && item.getAmount() == this.getAmount();
    }

    public int hashCode() {
        int hash = 1;
        hash = 31 * hash + this.tag.getKey().hashCode();
        hash = 31 * hash + this.getAmount();
        return hash;
    }

    @Override
    public JsonElement serialize(JsonSerializationContext context) {
        if (this.canUseShortSerialization()) {
            return new JsonPrimitive("#" + String.valueOf(this.tag.getKey()) + (String)(this.getAmount() != 1 ? "|" + this.getAmount() : ""));
        }
        JsonObject item = new JsonObject();
        item.addProperty("tag", this.tag.getKey().toString());
        if (this.getAmount() != 1) {
            item.addProperty("amount", (Number)this.getAmount());
        }
        return item;
    }
}

