/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.recipes.items;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.RecipeOutputItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.matching.RecipeMatchResult;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class RecipeOutputItemStack
extends RecipeOutputItem {
    private ItemStack template;

    public RecipeOutputItemStack(ItemStack template, int amount) {
        super(amount);
        this.template = template;
    }

    public RecipeOutputItemStack(ItemStack template) {
        this(template, template.getAmount());
    }

    public RecipeOutputItemStack(Material template, int amount) {
        super(amount);
        this.template = new ItemStack(template, amount);
    }

    public RecipeOutputItemStack(Material template) {
        this(template, 1);
    }

    public ItemStack getTemplate() {
        return this.template;
    }

    @Override
    public ItemStack generateOutput(RecipeMatchResult result) {
        return this.template.clone();
    }

    @Override
    public boolean matchItem(ItemStack item) {
        return SlimefunUtils.isItemSimilar(item, this.template, true);
    }

    @Override
    public String toString() {
        return "ROItemStack { " + String.valueOf(this.template) + ", " + super.toString() + " }";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RecipeOutputItemStack item = (RecipeOutputItemStack)obj;
        return item.template.equals((Object)this.template) && item.getAmount() == this.getAmount();
    }

    @Override
    public boolean canUseShortSerialization() {
        return super.canUseShortSerialization() && !this.template.hasItemMeta();
    }

    @Override
    public JsonElement serialize(JsonSerializationContext context) {
        if (this.canUseShortSerialization()) {
            return new JsonPrimitive(String.valueOf(this.template.getType().getKey()) + (String)(this.getAmount() != 1 ? "|" + this.getAmount() : ""));
        }
        JsonObject item = new JsonObject();
        item.addProperty("id", this.template.getType().getKey().toString());
        if (this.getAmount() != 1) {
            item.addProperty("amount", (Number)this.getAmount());
        }
        return item;
    }
}

