/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.recipes.items;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.AbstractRecipeOutputItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.RecipeOutputItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.RecipeOutputSlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.RecipeOutputTag;
import io.github.thebusybiscuit.slimefun4.api.recipes.matching.RecipeMatchResult;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.utils.RecipeUtils;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.inventory.ItemStack;

public abstract class RecipeOutputItem
extends AbstractRecipeOutputItem {
    public static final AbstractRecipeOutputItem EMPTY = new AbstractRecipeOutputItem(){

        @Override
        public boolean matchItem(ItemStack item) {
            return item == null || item.getType().isAir();
        }

        @Override
        public AbstractRecipeOutputItem.SpaceRequirement getSpaceRequirement() {
            return AbstractRecipeOutputItem.SpaceRequirement.MATCHING_ITEM;
        }

        @Override
        public ItemStack generateOutput(RecipeMatchResult result) {
            return new ItemStack(Material.AIR);
        }

        @Override
        public String toString() {
            return "EMPTY";
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }

        @Override
        public JsonElement serialize(JsonSerializationContext context) {
            return new JsonPrimitive("minecraft:air");
        }
    };
    private int amount;

    public RecipeOutputItem(int amount) {
        this.amount = amount;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    @Override
    public AbstractRecipeOutputItem.SpaceRequirement getSpaceRequirement() {
        return AbstractRecipeOutputItem.SpaceRequirement.MATCHING_ITEM;
    }

    public static AbstractRecipeOutputItem fromString(String string) {
        if (string == null) {
            return EMPTY;
        }
        String[] split = string.split(":");
        if (split.length != 2) {
            return EMPTY;
        }
        String[] pipeSplit = split[1].split("\\|");
        String namespace = split[0];
        String id = pipeSplit[0];
        int amount = 1;
        if (pipeSplit.length > 1) {
            amount = Integer.parseInt(pipeSplit[1]);
        }
        if (namespace.startsWith("#")) {
            Optional<Tag<Material>> tag = RecipeUtils.tagFromString(namespace.substring(1), id);
            if (tag.isPresent()) {
                return new RecipeOutputTag(tag.get(), amount);
            }
            return EMPTY;
        }
        if (namespace.equals("minecraft")) {
            Material mat = Material.matchMaterial((String)id);
            return mat == null ? EMPTY : new RecipeOutputItemStack(mat, amount);
        }
        if (namespace.equals("slimefun")) {
            return new RecipeOutputSlimefunItem(id.toUpperCase(), amount);
        }
        return EMPTY;
    }

    public static AbstractRecipeOutputItem fromItemStack(ItemStack item, int amount) {
        if (item == null || item.getType().isAir()) {
            return EMPTY;
        }
        if (item instanceof SlimefunItemStack) {
            SlimefunItemStack sfItem = (SlimefunItemStack)item;
            return new RecipeOutputSlimefunItem(sfItem.getItemId(), amount);
        }
        Optional<String> itemID = Slimefun.getItemDataService().getItemData(item);
        if (itemID.isPresent()) {
            return new RecipeOutputSlimefunItem(itemID.get(), amount);
        }
        return new RecipeOutputItemStack(item, amount);
    }

    public static AbstractRecipeOutputItem fromItemStack(ItemStack item) {
        if (item == null || item.getType().isAir()) {
            return EMPTY;
        }
        return RecipeOutputItem.fromItemStack(item, item.getAmount());
    }

    @Override
    public String toString() {
        return "amount=" + this.amount;
    }

    @Override
    public boolean canUseShortSerialization() {
        return true;
    }
}

