/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.recipes.items;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.AbstractRecipeOutputItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.matching.RecipeMatchResult;
import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.RandomizedSet;
import java.util.List;
import java.util.Map;
import org.bukkit.inventory.ItemStack;

public class RecipeOutputGroup
extends AbstractRecipeOutputItem {
    RandomizedSet<AbstractRecipeOutputItem> outputPool = new RandomizedSet();

    public RecipeOutputGroup(List<AbstractRecipeOutputItem> outputs, List<Integer> weights) {
        if (outputs.size() != weights.size()) {
            return;
        }
        for (int i = 0; i < outputs.size(); ++i) {
            this.outputPool.add(outputs.get(i), weights.get(i).intValue());
        }
    }

    public RandomizedSet<AbstractRecipeOutputItem> getOutputPool() {
        return this.outputPool;
    }

    @Override
    public ItemStack generateOutput(RecipeMatchResult result) {
        return this.outputPool.getRandom().generateOutput(result);
    }

    @Override
    public boolean matchItem(ItemStack item) {
        return false;
    }

    @Override
    public String toString() {
        return "ROGroup { " + String.valueOf(this.outputPool) + " }";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RecipeOutputGroup output = (RecipeOutputGroup)obj;
        return output.outputPool.toMap().equals(this.outputPool.toMap());
    }

    @Override
    public JsonElement serialize(JsonSerializationContext context) {
        JsonObject outputGroup = new JsonObject();
        JsonArray group = new JsonArray();
        JsonArray weights = new JsonArray();
        for (Map.Entry<AbstractRecipeOutputItem, Float> entry : this.outputPool.toMap().entrySet()) {
            group.add(context.serialize((Object)entry.getKey(), AbstractRecipeOutputItem.class));
            weights.add((Number)Math.round(entry.getValue().floatValue() * this.outputPool.sumWeights()));
        }
        outputGroup.add("group", (JsonElement)group);
        outputGroup.add("weights", (JsonElement)weights);
        return outputGroup;
    }
}

