/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.recipes.items;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.AbstractRecipeInputItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.RecipeInputItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.matching.ItemMatchResult;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.inventory.ItemStack;

public class RecipeInputTag
extends RecipeInputItem {
    private Tag<Material> tag;

    public RecipeInputTag(Tag<Material> tag, int amount, int durabilityCost) {
        super(amount, durabilityCost);
        this.tag = tag;
    }

    public RecipeInputTag(Tag<Material> tag, int amount) {
        super(amount);
        this.tag = tag;
    }

    public RecipeInputTag(Tag<Material> tag) {
        this(tag, 1);
    }

    public Tag<Material> getTag() {
        return this.tag;
    }

    public void setTag(Tag<Material> tag) {
        this.tag = tag;
    }

    @Override
    public ItemStack getItemDisplay() {
        return new ItemStack((Material)this.tag.getValues().stream().findFirst().get(), this.getAmount());
    }

    @Override
    public ItemMatchResult matchItem(ItemStack item, AbstractRecipeInputItem root) {
        if (item == null || item.getType().isAir()) {
            return new ItemMatchResult(this.isEmpty(), root, item, this.getAmount(), this.getDurabilityCost());
        }
        if (item.getAmount() < this.getAmount()) {
            return new ItemMatchResult(false, root, item, this.getAmount(), this.getDurabilityCost());
        }
        for (Material mat : this.tag.getValues()) {
            ItemStack template = new ItemStack(mat);
            if (!SlimefunUtils.isItemSimilar(item, template, true)) continue;
            return new ItemMatchResult(SlimefunUtils.isItemSimilar(item, template, false), root, item, this.getAmount(), this.getDurabilityCost());
        }
        return new ItemMatchResult(false, root, item, this.getAmount(), this.getDurabilityCost());
    }

    @Override
    public boolean isEmpty() {
        return this.tag.getValues().isEmpty() || this.getAmount() < 1;
    }

    @Override
    public RecipeInputTag clone() {
        return new RecipeInputTag(this.tag, this.getAmount(), this.getDurabilityCost());
    }

    @Override
    public String toString() {
        return "RITag { " + String.valueOf(this.tag) + ", " + super.toString() + " }";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RecipeInputTag item = (RecipeInputTag)obj;
        return item.tag.getKey().equals((Object)this.tag.getKey()) && item.getAmount() == this.getAmount() && item.getDurabilityCost() == this.getDurabilityCost();
    }

    @Override
    public int hashCode() {
        int hash = 1;
        hash = 31 * hash + this.tag.getKey().hashCode();
        hash = 31 * hash + this.getAmount();
        hash = 31 * hash + this.getDurabilityCost();
        return hash;
    }

    @Override
    public JsonElement serialize(JsonSerializationContext context) {
        if (this.canUseShortSerialization()) {
            return new JsonPrimitive("#" + String.valueOf(this.tag.getKey()) + (String)(this.getAmount() != 1 ? "|" + this.getAmount() : ""));
        }
        JsonObject item = new JsonObject();
        item.addProperty("tag", this.tag.getKey().toString());
        if (this.getAmount() != 1) {
            item.addProperty("amount", (Number)this.getAmount());
        }
        if (this.getDurabilityCost() != 0) {
            item.addProperty("durability", (Number)this.getDurabilityCost());
        }
        return item;
    }
}

