/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.recipes.items;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.AbstractRecipeInputItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.RecipeInputItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.matching.ItemMatchResult;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class RecipeInputSlimefunItem
extends RecipeInputItem {
    private String slimefunId;

    public RecipeInputSlimefunItem(String slimefunId, int amount, int durabilityCost) {
        super(amount, durabilityCost);
        this.slimefunId = slimefunId;
    }

    public RecipeInputSlimefunItem(String slimefunId, int amount) {
        this(slimefunId, amount, 0);
    }

    public RecipeInputSlimefunItem(String slimefunId) {
        this(slimefunId, 1);
    }

    public String getSlimefunId() {
        return this.slimefunId;
    }

    public void setSlimefunId(String slimefunId) {
        this.slimefunId = slimefunId;
    }

    @Override
    public ItemStack getItemDisplay() {
        SlimefunItem sfItem = SlimefunItem.getById(this.slimefunId);
        if (sfItem == null) {
            return new ItemStack(Material.AIR);
        }
        ItemStack display = sfItem.getItem();
        if (this.getAmount() != display.getAmount()) {
            display = sfItem.getItem().clone();
            display.setAmount(this.getAmount());
            return display;
        }
        return sfItem.getItem();
    }

    @Override
    public ItemMatchResult matchItem(ItemStack item, AbstractRecipeInputItem root) {
        if (item == null || item.getType().isAir()) {
            return new ItemMatchResult(this.isEmpty(), root, item, this.getAmount(), this.getDurabilityCost());
        }
        if (item.getAmount() < this.getAmount()) {
            return new ItemMatchResult(false, root, item, this.getAmount(), this.getDurabilityCost());
        }
        return new ItemMatchResult(SlimefunUtils.isItemSimilar(item, SlimefunItem.getById(this.slimefunId).getItem(), false), root, item, this.getAmount(), this.getDurabilityCost());
    }

    @Override
    public RecipeInputSlimefunItem clone() {
        return new RecipeInputSlimefunItem(this.slimefunId, this.getAmount(), this.getDurabilityCost());
    }

    @Override
    public String toString() {
        return "RISlimefunItem { id=" + this.slimefunId + ", " + super.toString() + " }";
    }

    @Override
    public boolean isEmpty() {
        return this.getAmount() < 1;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RecipeInputSlimefunItem item = (RecipeInputSlimefunItem)obj;
        return item.slimefunId.equals(this.slimefunId) && item.getAmount() == this.getAmount() && item.getDurabilityCost() == this.getDurabilityCost();
    }

    @Override
    public int hashCode() {
        int hash = 1;
        hash = 31 * hash + this.slimefunId.hashCode();
        hash = 31 * hash + this.getAmount();
        hash = 31 * hash + this.getDurabilityCost();
        return hash;
    }

    @Override
    public JsonElement serialize(JsonSerializationContext context) {
        if (this.canUseShortSerialization()) {
            return new JsonPrimitive("slimefun:" + this.slimefunId.toLowerCase() + (String)(this.getAmount() != 1 ? "|" + this.getAmount() : ""));
        }
        JsonObject item = new JsonObject();
        item.addProperty("id", "slimefun:" + this.slimefunId.toLowerCase());
        if (this.getAmount() != 1) {
            item.addProperty("amount", (Number)this.getAmount());
        }
        if (this.getDurabilityCost() != 0) {
            item.addProperty("durability", (Number)this.getDurabilityCost());
        }
        return item;
    }
}

