/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.recipes.items;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.AbstractRecipeInputItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.items.RecipeInputItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.matching.ItemMatchResult;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class RecipeInputItemStack
extends RecipeInputItem {
    @Nonnull
    private ItemStack template;

    @ParametersAreNonnullByDefault
    public RecipeInputItemStack(ItemStack template, int amount, int durabilityCost) {
        super(amount, durabilityCost);
        this.template = template;
    }

    @ParametersAreNonnullByDefault
    public RecipeInputItemStack(ItemStack template, int amount) {
        this(template, amount, 0);
    }

    @ParametersAreNonnullByDefault
    public RecipeInputItemStack(ItemStack template) {
        this(template, template.getAmount());
    }

    @ParametersAreNonnullByDefault
    public RecipeInputItemStack(Material template, int amount, int durabilityCost) {
        super(amount, durabilityCost);
        this.template = new ItemStack(template);
    }

    @ParametersAreNonnullByDefault
    public RecipeInputItemStack(Material template, int amount) {
        this(template, amount, 0);
    }

    @ParametersAreNonnullByDefault
    public RecipeInputItemStack(Material template) {
        this(template, 1);
    }

    @Nonnull
    public ItemStack getTemplate() {
        return this.template;
    }

    public void setTemplate(@Nonnull ItemStack template) {
        this.template = template;
    }

    @Override
    public ItemStack getItemDisplay() {
        if (this.getAmount() != this.template.getAmount()) {
            ItemStack display = this.template.clone();
            display.setAmount(this.getAmount());
            return display;
        }
        return this.template;
    }

    @Override
    public ItemMatchResult matchItem(ItemStack item, AbstractRecipeInputItem root) {
        if (item == null || item.getType().isAir()) {
            return new ItemMatchResult(this.isEmpty(), root, item, this.getAmount(), this.getDurabilityCost());
        }
        if (item.getAmount() < this.getAmount()) {
            return new ItemMatchResult(false, root, item, this.getAmount(), this.getDurabilityCost());
        }
        return new ItemMatchResult(SlimefunUtils.isItemSimilar(item, this.template, false), root, item, this.getAmount(), this.getDurabilityCost());
    }

    @Override
    public boolean isEmpty() {
        return this.template.getType().isAir() || this.getAmount() < 1;
    }

    @Override
    public RecipeInputItemStack clone() {
        return new RecipeInputItemStack(this.template.clone(), this.getAmount(), this.getDurabilityCost());
    }

    @Override
    public String toString() {
        return "RIItemStack { " + String.valueOf(this.template) + ", " + super.toString() + " }";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RecipeInputItemStack item = (RecipeInputItemStack)obj;
        return item.template.equals((Object)this.template) && item.getAmount() == this.getAmount() && item.getDurabilityCost() == this.getDurabilityCost();
    }

    @Override
    public int hashCode() {
        int hash = 1;
        hash = 31 * hash + this.template.hashCode();
        hash = 31 * hash + this.getAmount();
        hash = 31 * hash + this.getDurabilityCost();
        return hash;
    }

    @Override
    public boolean canUseShortSerialization() {
        return super.canUseShortSerialization() && !this.template.hasItemMeta();
    }

    @Override
    public JsonElement serialize(JsonSerializationContext context) {
        if (this.canUseShortSerialization()) {
            return new JsonPrimitive(String.valueOf(this.template.getType().getKey()) + (String)(this.getAmount() != 1 ? "|" + this.getAmount() : ""));
        }
        JsonObject item = new JsonObject();
        item.addProperty("id", this.template.getType().getKey().toString());
        if (this.getAmount() != 1) {
            item.addProperty("amount", (Number)this.getAmount());
        }
        if (this.getDurabilityCost() != 0) {
            item.addProperty("durability", (Number)this.getDurabilityCost());
        }
        return item;
    }
}

